/*
 * Copyright (c) 2006-2025 Progress Software Corporation and/or its subsidiaries or affiliates. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.marklogic.xcc.impl.handlers;

import com.marklogic.http.HttpChannel;
import com.marklogic.xcc.Request;
import com.marklogic.xcc.exceptions.PDCloudRequestException;
import com.marklogic.xcc.exceptions.UnexpectedResponseException;

import java.io.IOException;
import java.util.logging.Logger;

public class PDCloudGoneHandler implements ResponseHandler {
    @Override
    public Object handleResponse(HttpChannel http, int responseCode,
                                 Request request, Object attachment,
                                 Logger logger)
        throws PDCloudRequestException {
        String responseMsg = getResponseMessage(http);
        if (request.getSession().getUserCredentials().getPDCloudAuthConfig()
            != null) {
            // Response from Progress Data Cloud
            throw new PDCloudRequestException("(" + responseCode + ", " +
                responseMsg + "). " + "MarkLogic Tenant has expired. ", request,
                false);
        } else return null;
    }

    private String getResponseMessage(HttpChannel http) {
        try {
            return http.getResponseMessage();
        } catch (IOException e) {
            return ("No Message");
        }
    }
}
