/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.gradle.python.util.internal.pex;

import com.linkedin.gradle.python.PythonExtension;
import com.linkedin.gradle.python.extension.DeployableExtension;
import com.linkedin.gradle.python.extension.PexExtension;
import com.linkedin.gradle.python.extension.WheelExtension;
import com.linkedin.gradle.python.util.ExtensionUtils;
import com.linkedin.gradle.python.util.PexFileUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.process.ExecSpec;

class PexExecSpecAction
implements Action<ExecSpec> {
    private final PythonExtension pythonExtension;
    private final File pexCache;
    private final File outputFile;
    private final File wheelCache;
    private final File pexShebang;
    private final String entryPoint;
    private final List<String> pexOptions;
    private final Map<String, String> dependencies;
    private final ByteArrayOutputStream outputStream;

    private PexExecSpecAction(PythonExtension pythonExtension, File pexCache, File outputFile, File wheelCache, File pexShebang, String entryPoint, List<String> pexOptions, Map<String, String> dependencies) {
        this.pythonExtension = pythonExtension;
        this.pexCache = pexCache;
        this.outputFile = outputFile;
        this.wheelCache = wheelCache;
        this.pexShebang = pexShebang;
        this.entryPoint = entryPoint;
        this.pexOptions = pexOptions;
        this.dependencies = dependencies;
        this.outputStream = new ByteArrayOutputStream();
    }

    public void execute(ExecSpec execSpec) {
        execSpec.commandLine(new Object[]{this.pythonExtension.getDetails().getVirtualEnvInterpreter()});
        execSpec.args(new Object[]{this.pythonExtension.getDetails().getVirtualEnvironment().getPex()});
        System.out.println(this.outputFile.getAbsolutePath());
        execSpec.args(Arrays.asList("--no-pypi", "--cache-dir", this.pexCache.getAbsolutePath(), "--output-file", this.outputFile.getAbsolutePath(), "--repo", this.wheelCache.getAbsolutePath(), "--python-shebang", this.pexShebang.getAbsolutePath()));
        if (this.entryPoint != null) {
            execSpec.args(Arrays.asList("--entry-point", this.entryPoint));
        }
        execSpec.args(this.pexOptions);
        execSpec.args(this.pexRequirements(this.dependencies));
        execSpec.setStandardOutput((OutputStream)this.outputStream);
        execSpec.setErrorOutput((OutputStream)this.outputStream);
        execSpec.setIgnoreExitValue(true);
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public static PexExecSpecAction withEntryPoint(Project project, String pexName, String entryPoint, List<String> pexOptions, Map<String, String> dependencies) {
        PythonExtension pythonExtension = ExtensionUtils.getPythonExtension(project);
        PexExtension pexExtension = ExtensionUtils.getPythonComponentExtension(project, PexExtension.class);
        WheelExtension wheelExtension = ExtensionUtils.getPythonComponentExtension(project, WheelExtension.class);
        DeployableExtension deployableExtension = ExtensionUtils.getPythonComponentExtension(project, DeployableExtension.class);
        return new PexExecSpecAction(pythonExtension, pexExtension.getPexCache(), new File(deployableExtension.getDeployableBinDir(), pexName), wheelExtension.getWheelCache(), pythonExtension.getDetails().getSystemPythonInterpreter(), entryPoint, pexOptions, dependencies);
    }

    public static PexExecSpecAction withOutEntryPoint(Project project, String pexName, List<String> pexOptions, Map<String, String> dependencies) {
        PythonExtension pythonExtension = ExtensionUtils.getPythonExtension(project);
        PexExtension pexExtension = ExtensionUtils.getPythonComponentExtension(project, PexExtension.class);
        WheelExtension wheelExtension = ExtensionUtils.getPythonComponentExtension(project, WheelExtension.class);
        DeployableExtension deployableExtension = ExtensionUtils.getPythonComponentExtension(project, DeployableExtension.class);
        return new PexExecSpecAction(pythonExtension, pexExtension.getPexCache(), new File(deployableExtension.getDeployableBinDir(), PexFileUtil.createThinPexFilename(pexName)), wheelExtension.getWheelCache(), pythonExtension.getDetails().getSystemPythonInterpreter(), null, pexOptions, dependencies);
    }

    private List<String> pexRequirements(Map<String, String> dependencies) {
        ArrayList<String> requirements = new ArrayList<String>();
        for (Map.Entry<String, String> entry : dependencies.entrySet()) {
            requirements.add(entry.getKey() + "==" + entry.getValue());
        }
        return requirements;
    }
}

