/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.gradle.python.util.internal.pex;

import com.linkedin.gradle.python.util.internal.pex.PexExecSpecAction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.GradleException;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.process.ExecResult;

class PexExecOutputParser {
    private static final Logger logger = Logging.getLogger(PexExecOutputParser.class);
    private final String outputFromPexCommand;
    private final int returnCode;

    PexExecOutputParser(PexExecSpecAction pexExecSpecAction, ExecResult execResult) {
        this(pexExecSpecAction.getOutputStream().toString().trim(), execResult.getExitValue());
    }

    PexExecOutputParser(String outputFromPexCommand, int returnCode) {
        this.outputFromPexCommand = outputFromPexCommand;
        this.returnCode = returnCode;
    }

    void validatePexBuildSuccessfully() {
        if (this.returnCode == 0) {
            return;
        }
        String packageName = "<see output above>";
        logger.lifecycle(this.outputFromPexCommand);
        Pattern pattern = Pattern.compile("(?s).*Could not satisfy all requirements for ([\\w.-]+):.*");
        Matcher matcher = pattern.matcher(this.outputFromPexCommand);
        if (matcher.matches()) {
            packageName = matcher.group(1);
        }
        String lineSeperator = System.getProperty("line.separator");
        throw new GradleException("Failed to build a pex file (see output above)!" + lineSeperator + lineSeperator + "This typically happens because your virtual environment contains a cached copy of " + packageName + lineSeperator + "that no other package depends on any more." + lineSeperator + "Usually, this is the result of updating a package that used to depend on " + packageName + ".");
    }
}

