/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.gradle.python.util.internal.pex;

import com.linkedin.gradle.python.PythonExtension;
import com.linkedin.gradle.python.util.EntryPointHelpers;
import com.linkedin.gradle.python.util.PexFileUtil;
import com.linkedin.gradle.python.util.internal.pex.PexExecOutputParser;
import com.linkedin.gradle.python.util.internal.pex.PexExecSpecAction;
import com.linkedin.gradle.python.util.internal.zipapp.ZipappGenerator;
import com.linkedin.gradle.python.util.pip.PipFreezeAction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.process.ExecResult;

public class FatPexGenerator
implements ZipappGenerator {
    private static final Logger logger = Logging.getLogger(FatPexGenerator.class);
    private final Project project;
    private final List<String> pexOptions;

    public FatPexGenerator(Project project, List<String> pexOptions) {
        this.project = project;
        this.pexOptions = pexOptions;
    }

    @Override
    public Map<String, String> buildSubstitutions(PythonExtension extension, String entry) {
        return new HashMap<String, String>();
    }

    @Override
    public void buildEntryPoints() {
        Map<String, String> dependencies = new PipFreezeAction(this.project).getDependencies();
        for (String it : EntryPointHelpers.collectEntryPoints(this.project)) {
            logger.lifecycle("Processing entry point: {}", new Object[]{it});
            String[] split = it.split("=");
            String name = PexFileUtil.createFatPexFilename(split[0].trim());
            String entry = split[1].trim();
            this.buildEntryPoint(name, entry, dependencies);
        }
    }

    public void buildEntryPoint(String name, String entry, Map<String, String> pipFreezeDependencies) {
        Map<String, String> dependencies = pipFreezeDependencies;
        if (dependencies == null) {
            dependencies = new PipFreezeAction(this.project).getDependencies();
        }
        PexExecSpecAction action = PexExecSpecAction.withEntryPoint(this.project, name, entry, this.pexOptions, dependencies);
        ExecResult exec = this.project.exec((Action)action);
        new PexExecOutputParser(action, exec).validatePexBuildSuccessfully();
    }
}

