/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.gradle.python.util.entrypoint;

import com.linkedin.gradle.python.extension.CliExtension;
import com.linkedin.gradle.python.extension.ZipappContainerExtension;
import com.linkedin.gradle.python.util.ExtensionUtils;
import groovy.text.SimpleTemplateEngine;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.gradle.api.Project;

public class EntryPointWriter {
    private final String template;
    private final boolean isCliTool;
    private final boolean isZipapp;

    public EntryPointWriter(Project project, String template) {
        this.template = template;
        this.isCliTool = ExtensionUtils.findPythonComponentExtension(project, CliExtension.class) != null;
        this.isZipapp = ExtensionUtils.findPythonComponentExtension(project, ZipappContainerExtension.class) != null;
    }

    public void writeEntryPoint(File location, Map<String, String> properties) throws IOException, ClassNotFoundException {
        if (location.exists()) {
            location.delete();
        }
        location.createNewFile();
        SimpleTemplateEngine simpleTemplateEngine = new SimpleTemplateEngine();
        String rendered = simpleTemplateEngine.createTemplate(this.template).make(properties).toString();
        FileUtils.write((File)location, (CharSequence)rendered);
        if (this.isCliTool || this.isZipapp) {
            location.setExecutable(true, false);
            location.setReadable(true, false);
        } else {
            location.setExecutable(true);
        }
    }
}

