/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.gradle.python.util;

import com.linkedin.gradle.python.util.OperatingSystem;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;

public class FileSystemUtils {
    private FileSystemUtils() {
    }

    public static void makeSymLink(File target, File destination) throws IOException {
        if (OperatingSystem.current().isUnix()) {
            if (!Files.exists(destination.toPath(), new LinkOption[0])) {
                Files.createSymbolicLink(destination.toPath(), target.toPath(), new FileAttribute[0]);
            }
        } else if (!Files.exists(destination.toPath(), new LinkOption[0])) {
            Files.copy(target.toPath(), destination.toPath(), new CopyOption[0]);
        }
    }

    public static void makeSymLinkUnchecked(File target, File destination) {
        try {
            FileSystemUtils.makeSymLink(target, destination);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

