/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.gradle.python.util;

import com.linkedin.gradle.python.PythonExtension;
import com.linkedin.gradle.python.extension.CliExtension;
import com.linkedin.gradle.python.extension.DeployableExtension;
import com.linkedin.gradle.python.extension.PexExtension;
import com.linkedin.gradle.python.extension.WheelExtension;
import com.linkedin.gradle.python.wheel.EditablePythonAbiContainer;
import org.gradle.api.Project;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.ExtensionContainer;

public class ExtensionUtils {
    private ExtensionUtils() {
    }

    public static <T> T maybeCreate(Project project, String name, Class<T> type, Object ... args) {
        PythonExtension extension = ExtensionUtils.getPythonExtension(project);
        return ExtensionUtils.maybeCreate(extension, name, type, args);
    }

    public static <T> T maybeCreate(PythonExtension extension, String name, Class<T> type, Object ... args) {
        ExtensionContainer extensionContainer = ((ExtensionAware)extension).getExtensions();
        Object maybeExtension = extensionContainer.findByType(type);
        if (maybeExtension == null) {
            maybeExtension = extensionContainer.create(name, type, args);
        }
        return (T)maybeExtension;
    }

    public static DeployableExtension maybeCreateDeployableExtension(Project project) {
        return ExtensionUtils.maybeCreate(project, "deployable", DeployableExtension.class, project);
    }

    public static PexExtension maybeCreatePexExtension(Project project) {
        return ExtensionUtils.maybeCreate(project, "pex", PexExtension.class, project);
    }

    public static WheelExtension maybeCreateWheelExtension(Project project) {
        return ExtensionUtils.maybeCreate(project, "wheel", WheelExtension.class, project);
    }

    public static CliExtension maybeCreateCliExtension(Project project) {
        return ExtensionUtils.maybeCreate(project, "cli", CliExtension.class, new Object[0]);
    }

    public static <T> T getPythonComponentExtension(Project project, Class<T> type) {
        PythonExtension extension = ExtensionUtils.getPythonExtension(project);
        return ExtensionUtils.getPythonComponentExtension(extension, type);
    }

    public static <T> T getPythonComponentExtension(PythonExtension extension, Class<T> type) {
        ExtensionContainer extensionContainer = ((ExtensionAware)extension).getExtensions();
        return (T)extensionContainer.getByType(type);
    }

    public static <T> T findPythonComponentExtension(Project project, Class<T> type) {
        PythonExtension extension = ExtensionUtils.getPythonExtension(project);
        return ExtensionUtils.findPythonComponentExtension(extension, type);
    }

    public static <T> T findPythonComponentExtension(PythonExtension extension, Class<T> type) {
        ExtensionContainer extensionContainer = ((ExtensionAware)extension).getExtensions();
        return (T)extensionContainer.findByType(type);
    }

    public static PythonExtension getPythonExtension(Project project) {
        return (PythonExtension)project.getExtensions().getByType(PythonExtension.class);
    }

    public static EditablePythonAbiContainer getEditablePythonAbiContainer(Project project) {
        return ExtensionUtils.getPythonComponentExtension(project, EditablePythonAbiContainer.class);
    }
}

