/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.gradle.python.util;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public class DependencyOrder {
    private static final Logger logger = Logging.getLogger(DependencyOrder.class);

    private DependencyOrder() {
    }

    public static ResolvedComponentResult postOrderDependencies(ResolvedComponentResult root, Set<ComponentIdentifier> seen, Set<ResolvedComponentResult> dependencies) {
        for (DependencyResult d : root.getDependencies()) {
            if (!(d instanceof ResolvedDependencyResult)) {
                throw new GradleException("Unresolved dependency found for " + d.toString());
            }
            ResolvedComponentResult component = ((ResolvedDependencyResult)d).getSelected();
            ComponentIdentifier id = component.getId();
            if (seen.contains(id)) continue;
            seen.add(id);
            dependencies.add(DependencyOrder.postOrderDependencies(component, seen, dependencies));
        }
        return root;
    }

    public static Set<ResolvedComponentResult> configurationPostOrderDependencies(Configuration configuration) {
        ResolvedComponentResult root = configuration.getIncoming().getResolutionResult().getRoot();
        LinkedHashSet<ResolvedComponentResult> dependencies = new LinkedHashSet<ResolvedComponentResult>();
        HashSet<ComponentIdentifier> seen = new HashSet<ComponentIdentifier>();
        DependencyOrder.postOrderDependencies(root, seen, dependencies);
        return dependencies;
    }

    public static Collection<File> configurationPostOrderFiles(Configuration configuration) {
        HashMap<ModuleVersionIdentifier, File> idToFileMap = new HashMap<ModuleVersionIdentifier, File>();
        LinkedHashSet<File> files = new LinkedHashSet<File>();
        Set configurationFiles = configuration.getFiles();
        Set artifacts = configuration.getResolvedConfiguration().getResolvedArtifacts();
        for (ResolvedArtifact artifact : artifacts) {
            ModuleVersionIdentifier id = artifact.getModuleVersion().getId();
            File file = artifact.getFile();
            idToFileMap.put(id, file);
        }
        for (ResolvedComponentResult d : DependencyOrder.configurationPostOrderDependencies(configuration)) {
            if (!idToFileMap.containsKey(d.getModuleVersion())) {
                logger.warn("***** WARNING Missing resolved artifact for " + d);
                continue;
            }
            files.add((File)idToFileMap.get(d.getModuleVersion()));
        }
        if (!configurationFiles.containsAll(files)) {
            throw new GradleException("Could not find matching dependencies for all configuration files");
        }
        if (files.size() != configurationFiles.size()) {
            files.addAll(DependencyOrder.difference(configurationFiles, files));
        }
        return files;
    }

    public static Collection<File> getConfigurationFiles(FileCollection files, boolean sorted) {
        if (sorted && files instanceof Configuration) {
            try {
                return DependencyOrder.configurationPostOrderFiles((Configuration)files);
            }
            catch (Throwable e) {
                logger.lifecycle("***** WARNING: ${ e.message } *****");
            }
        }
        return sorted ? (Collection)files.getFiles().stream().sorted().collect(Collectors.toSet()) : files.getFiles();
    }

    public static Collection<File> getConfigurationFiles(FileCollection files) {
        return DependencyOrder.getConfigurationFiles(files, true);
    }

    private static Set<File> difference(Set<File> larger, Set<File> smaller) {
        LinkedHashSet<File> diff = new LinkedHashSet<File>();
        for (File file : larger) {
            if (smaller.contains(file)) continue;
            diff.add(file);
        }
        return diff;
    }
}

