/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.gradle.python.tasks.action.pip;

import com.linkedin.gradle.python.exception.PipExecutionException;
import com.linkedin.gradle.python.extension.PythonDetails;
import com.linkedin.gradle.python.plugin.PythonHelpers;
import com.linkedin.gradle.python.tasks.action.pip.AbstractPipAction;
import com.linkedin.gradle.python.tasks.exec.ExternalExec;
import com.linkedin.gradle.python.util.EnvironmentMerger;
import com.linkedin.gradle.python.util.PackageInfo;
import com.linkedin.gradle.python.util.PackageSettings;
import com.linkedin.gradle.python.wheel.WheelCache;
import com.linkedin.gradle.python.wheel.WheelCacheLayer;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.specs.Spec;
import org.gradle.process.ExecResult;

public class WheelBuilder
extends AbstractPipAction {
    private static final List<String> NOT_WHEEL_OPTIONS = Arrays.asList("--upgrade", "--ignore-installed");
    private static final Map<String, List<String>> CUSTOM_ENVIRONMENT = Collections.unmodifiableMap(Stream.of(new AbstractMap.SimpleEntry<String, List<String>>("numpy", Arrays.asList("ATLAS", "BLAS", "LAPACK", "OPENBLAS")), new AbstractMap.SimpleEntry<String, List<String>>("pycurl", Collections.singletonList("PYCURL_SSL_LIBRARY"))).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue)));
    private static final Logger logger = Logging.getLogger(WheelBuilder.class);
    private boolean customBuild = true;

    WheelBuilder(PackageSettings<PackageInfo> packageSettings, Project project, ExternalExec externalExec, Map<String, String> baseEnvironment, PythonDetails pythonDetails, WheelCache wheelCache, EnvironmentMerger environmentMerger, Spec<PackageInfo> packageExcludeFilter) {
        super(packageSettings, project, externalExec, baseEnvironment, pythonDetails, wheelCache, environmentMerger, packageExcludeFilter);
    }

    @Override
    Logger getLogger() {
        return logger;
    }

    @Override
    public void execute(PackageInfo packageInfo, List<String> extraArgs) {
        this.doPipOperation(packageInfo, extraArgs);
    }

    @Override
    void doPipOperation(PackageInfo packageInfo, List<String> extraArgs) {
        ByteArrayOutputStream stream;
        Map<String, String> mergedEnv;
        ExecResult installResult;
        List<String> commandLine = this.makeCommandLine(packageInfo, extraArgs);
        if (commandLine.isEmpty()) {
            return;
        }
        if (PythonHelpers.isPlainOrVerbose(this.project)) {
            logger.lifecycle("Building wheel for {}", new Object[]{packageInfo.toShortHand()});
        }
        if ((installResult = this.execCommand(mergedEnv = this.customBuild ? this.environmentMerger.mergeEnvironments(Arrays.asList(this.baseEnvironment, this.packageSettings.getEnvironment(packageInfo))) : this.packageSettings.getEnvironment(packageInfo), commandLine, stream = new ByteArrayOutputStream())).getExitValue() != 0) {
            logger.error("Error building package wheel using `{}`", commandLine);
            logger.error(((Object)stream).toString().trim());
            throw PipExecutionException.failedWheel(packageInfo, ((Object)stream).toString().trim());
        }
        logger.info(((Object)stream).toString().trim());
    }

    File getPackage(PackageInfo packageInfo, List<String> extraArgs) {
        Optional<File> wheel;
        File packageFile = packageInfo.getPackageFile();
        if (!this.wheelCache.getTargetDirectory().isPresent()) {
            return packageFile;
        }
        if (this.isPackageDirectory(packageInfo) && this.project.getProjectDir().equals(packageFile)) {
            return packageFile;
        }
        String name = packageInfo.getName();
        String version = packageInfo.getVersion();
        if (this.isPackageDirectory(packageInfo)) {
            version = this.project.getVersion().toString();
        }
        if (name == null || version == null) {
            return packageFile;
        }
        boolean bl = this.customBuild = this.packageSettings.requiresSourceBuild(packageInfo) || this.packageSettings.isCustomized(packageInfo) || this.isCustomEnvironment(name);
        if (!this.packageSettings.requiresSourceBuild(packageInfo)) {
            wheel = this.wheelCache.findWheel(name, version, this.pythonDetails, WheelCacheLayer.PROJECT_LAYER);
            if (wheel.isPresent()) {
                packageFile = wheel.get();
                this.logLifecycle(packageInfo, packageFile);
                return packageFile;
            }
            if (!this.customBuild && (wheel = this.wheelCache.findWheel(name, version, this.pythonDetails, WheelCacheLayer.HOST_LAYER)).isPresent()) {
                packageFile = wheel.get();
                this.wheelCache.storeWheel(packageFile, WheelCacheLayer.PROJECT_LAYER);
                this.logLifecycle(packageInfo, packageFile);
                return packageFile;
            }
        }
        try {
            this.execute(packageInfo, extraArgs);
        }
        catch (PipExecutionException e) {
            if (!this.customBuild) {
                this.customBuild = true;
                try {
                    this.execute(packageInfo, extraArgs);
                }
                catch (PipExecutionException ignored) {
                    this.wheelCache.setWheelsReady(false);
                }
            }
            this.wheelCache.setWheelsReady(false);
        }
        wheel = this.wheelCache.findWheel(name, version, this.pythonDetails, WheelCacheLayer.PROJECT_LAYER);
        if (wheel.isPresent()) {
            packageFile = wheel.get();
            if (!this.customBuild) {
                this.wheelCache.storeWheel(packageFile, WheelCacheLayer.HOST_LAYER);
            }
        }
        return packageFile;
    }

    void updateWheelReadiness(PackageInfo packageInfo) {
        if (this.wheelCache.isWheelsReady()) {
            String name = packageInfo.getName();
            String version = packageInfo.getVersion();
            Optional<Object> wheel = name == null || version == null ? Optional.empty() : this.wheelCache.findWheel(name, version, this.pythonDetails, WheelCacheLayer.PROJECT_LAYER);
            if (!wheel.isPresent()) {
                this.wheelCache.setWheelsReady(false);
            }
        }
    }

    private List<String> makeCommandLine(PackageInfo packageInfo, List<String> extraArgs) {
        ArrayList<String> commandLine = new ArrayList<String>();
        Optional<File> targetDir = this.wheelCache.getTargetDirectory();
        if (targetDir.isPresent()) {
            String wheelDirPath = targetDir.get().toString();
            commandLine.addAll(Arrays.asList(this.pythonDetails.getVirtualEnvInterpreter().toString(), this.pythonDetails.getVirtualEnvironment().getPip().toString(), "wheel", "--disable-pip-version-check", "--wheel-dir", wheelDirPath, "--no-deps"));
            commandLine.addAll(this.cleanupArgs(extraArgs));
            commandLine.addAll(this.getGlobalOptions(packageInfo));
            commandLine.addAll(this.getBuildOptions(packageInfo));
            commandLine.add(packageInfo.getPackageFile().toString());
        }
        return commandLine;
    }

    private List<String> cleanupArgs(List<String> args) {
        ArrayList<String> cleanArgs = new ArrayList<String>(args);
        cleanArgs.removeAll(NOT_WHEEL_OPTIONS);
        return cleanArgs;
    }

    private boolean isPackageDirectory(PackageInfo packageInfo) {
        File packageDir = packageInfo.getPackageFile();
        String version = packageInfo.getVersion();
        return version == null && Files.isDirectory(packageDir.toPath(), new LinkOption[0]);
    }

    private boolean isCustomEnvironment(String name) {
        if (CUSTOM_ENVIRONMENT.containsKey(name)) {
            for (String entry : CUSTOM_ENVIRONMENT.get(name)) {
                if (!this.baseEnvironment.containsKey(entry)) continue;
                return true;
            }
        }
        return false;
    }

    private void logLifecycle(PackageInfo packageInfo, File packageFile) {
        if (PythonHelpers.isPlainOrVerbose(this.project)) {
            logger.lifecycle("{} from wheel: {}", new Object[]{packageInfo.toShortHand(), packageFile.getAbsolutePath()});
        }
    }
}

