/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.gradle.python.tasks.action.pip;

import com.linkedin.gradle.python.exception.PipExecutionException;
import com.linkedin.gradle.python.extension.PythonDetails;
import com.linkedin.gradle.python.extension.WheelExtension;
import com.linkedin.gradle.python.plugin.PythonHelpers;
import com.linkedin.gradle.python.tasks.action.pip.AbstractPipAction;
import com.linkedin.gradle.python.tasks.exec.ExternalExec;
import com.linkedin.gradle.python.util.EnvironmentMerger;
import com.linkedin.gradle.python.util.PackageInfo;
import com.linkedin.gradle.python.util.PackageSettings;
import com.linkedin.gradle.python.wheel.WheelCache;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.specs.Spec;
import org.gradle.process.ExecResult;

public class PipWheelAction
extends AbstractPipAction {
    private static Logger logger = Logging.getLogger(PipWheelAction.class);
    private final WheelExtension wheelExtension;

    public PipWheelAction(PackageSettings<PackageInfo> packageSettings, Project project, ExternalExec externalExec, Map<String, String> baseEnvironment, PythonDetails pythonDetails, WheelCache wheelCache, EnvironmentMerger environmentMerger, WheelExtension wheelExtension, Spec<PackageInfo> packageExcludeFilter) {
        super(packageSettings, project, externalExec, baseEnvironment, pythonDetails, wheelCache, environmentMerger, packageExcludeFilter);
        this.wheelExtension = wheelExtension;
    }

    @Override
    Logger getLogger() {
        return logger;
    }

    @Override
    void doPipOperation(PackageInfo packageInfo, List<String> extraArgs) {
        ByteArrayOutputStream stream;
        List<String> commandLine;
        Map<String, String> mergedEnv;
        ExecResult installResult;
        this.throwIfPythonVersionIsNotSupported(packageInfo);
        if (!this.packageSettings.requiresSourceBuild(packageInfo) && this.doesWheelExist(packageInfo)) {
            return;
        }
        if (PythonHelpers.isPlainOrVerbose(this.project)) {
            logger.lifecycle("Building {} wheel", new Object[]{packageInfo.toShortHand()});
        }
        if ((installResult = this.execCommand(mergedEnv = this.environmentMerger.mergeEnvironments(Arrays.asList(this.baseEnvironment, this.packageSettings.getEnvironment(packageInfo))), commandLine = this.makeCommandLine(packageInfo, extraArgs), stream = new ByteArrayOutputStream())).getExitValue() != 0) {
            logger.error("Error installing package using `{}`", commandLine);
            logger.error(((Object)stream).toString().trim());
            throw PipExecutionException.failedWheel(packageInfo, ((Object)stream).toString().trim());
        }
        logger.info(((Object)stream).toString().trim());
    }

    private boolean doesWheelExist(PackageInfo packageInfo) {
        Optional<File> wheel;
        if (!this.packageSettings.isCustomized(packageInfo) && (wheel = this.wheelCache.findWheel(packageInfo.getName(), packageInfo.getVersion(), this.pythonDetails)).isPresent()) {
            File wheelCopy;
            File wheelFile = wheel.get();
            if (!wheelFile.equals(wheelCopy = new File(this.wheelExtension.getWheelCache(), wheelFile.getName()))) {
                try {
                    FileUtils.copyFile((File)wheelFile, (File)wheelCopy);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            if (PythonHelpers.isPlainOrVerbose(this.project)) {
                logger.lifecycle("Skipping {}, in wheel cache {}", new Object[]{packageInfo.toShortHand(), wheelFile});
            }
            return true;
        }
        ConfigurableFileTree tree = this.project.fileTree((Object)this.wheelExtension.getWheelCache(), action -> {
            String sanitizedName = packageInfo.getName().replace('-', '_');
            String sanitizedVersion = (packageInfo.getVersion() == null ? "unspecified" : packageInfo.getVersion()).replace('-', '_');
            action.include(new String[]{"**/" + sanitizedName + "-" + sanitizedVersion + "-*.whl"});
        });
        if (tree.getFiles().size() >= 1) {
            if (PythonHelpers.isPlainOrVerbose(this.project)) {
                logger.lifecycle("Skipping {} wheel - Installed", new Object[]{packageInfo.toShortHand()});
            }
            return true;
        }
        return false;
    }

    private List<String> makeCommandLine(PackageInfo packageInfo, List<String> extraArgs) {
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.addAll(Arrays.asList(this.pythonDetails.getVirtualEnvInterpreter().toString(), this.pythonDetails.getVirtualEnvironment().getPip().toString(), "wheel", "--disable-pip-version-check", "--wheel-dir", this.wheelExtension.getWheelCache().toString(), "--no-deps"));
        commandLine.addAll(extraArgs);
        commandLine.addAll(this.getGlobalOptions(packageInfo));
        commandLine.addAll(this.getBuildOptions(packageInfo));
        commandLine.add(packageInfo.getPackageFile().toString());
        return commandLine;
    }
}

