/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.gradle.python.tasks;

import com.linkedin.gradle.python.extension.WheelExtension;
import com.linkedin.gradle.python.util.ExtensionUtils;
import java.io.File;
import java.util.Optional;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

public class LayeredWheelCacheTask
extends DefaultTask {
    public static final String TASK_LAYERED_WHEEL_CACHE = "layeredWheelCacheTask";

    @TaskAction
    public void makeCacheDirectories() {
    }

    @OutputDirectory
    public File getHostLayerWheelCache() {
        WheelExtension wheelExtension = ExtensionUtils.getPythonComponentExtension(this.getProject(), WheelExtension.class);
        Optional<File> cacheDir = wheelExtension.getHostLayerWheelCache();
        if (!cacheDir.isPresent()) {
            cacheDir = Optional.of(new File(this.getProject().getGradle().getGradleUserHomeDir(), "pygradle/wheel-cache"));
            wheelExtension.setHostLayerWheelCache(cacheDir.get());
        }
        return cacheDir.get();
    }

    @OutputDirectory
    public File getProjectLayerWheelCache() {
        WheelExtension wheelExtension = ExtensionUtils.getPythonComponentExtension(this.getProject(), WheelExtension.class);
        Optional<File> cacheDir = wheelExtension.getProjectLayerWheelCache();
        if (!cacheDir.isPresent()) {
            cacheDir = Optional.of(new File(this.getProject().getBuildDir(), "wheel-cache"));
            wheelExtension.setProjectLayerWheelCache(cacheDir.get());
        }
        return cacheDir.get();
    }
}

