/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.gradle.python.tasks;

import com.linkedin.gradle.python.PythonExtension;
import com.linkedin.gradle.python.tasks.AbstractPythonMainSourceDefaultTask;
import com.linkedin.gradle.python.util.ExtensionUtils;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.process.ExecResult;

public class Flake8Task
extends AbstractPythonMainSourceDefaultTask {
    private static final Logger log = Logging.getLogger(Flake8Task.class);
    private Boolean ignoringNewRules = false;
    private String firstRunOutput = null;
    private Set<String> ignoreRules = new HashSet<String>();
    private static final String IGNORED_RULES_MSG = "######################### WARNING ##########################\nThe flake8 version has been recently updated, which added the following new rules:\n%s\nYour project is failing for one or more of these rules. Please address them, as they will be enforced soon.\n%s############################################################\n";

    public void setIgnoreRules(Set<String> ignoreRules) {
        this.ignoreRules = ignoreRules;
    }

    public Set<String> getIgnoreRules() {
        return this.ignoreRules;
    }

    @Override
    public void preExecution() {
        this.ignoreExitValue = true;
        PythonExtension pythonExtension = ExtensionUtils.getPythonExtension(this.getProject());
        File flake8Exec = pythonExtension.getDetails().getVirtualEnvironment().findExecutable("flake8");
        ArrayList<String> paths = new ArrayList<String>();
        if (this.getProject().file((Object)pythonExtension.srcDir).exists()) {
            log.info("Flake8: adding {}", (Object)pythonExtension.srcDir);
            paths.add(pythonExtension.srcDir);
        } else {
            log.info("Flake8: srcDir doesn't exist");
        }
        if (this.getProject().file((Object)pythonExtension.testDir).exists()) {
            log.info("Flake8: adding {}", (Object)pythonExtension.testDir);
            paths.add(pythonExtension.testDir);
        } else {
            log.info("Flake8: testDir doesn't exist");
        }
        this.args(Arrays.asList(flake8Exec.getAbsolutePath(), "--config", pythonExtension.setupCfg));
        File cfgCheck = this.getProject().file((Object)pythonExtension.setupCfg);
        if (!cfgCheck.exists()) {
            log.info("Flake8 config file doesn't exist, creating default");
            try {
                FileUtils.write((File)cfgCheck, (CharSequence)"[flake8]");
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        } else {
            log.info("Flake8 config file exists");
        }
        this.args(paths);
    }

    @Override
    public void processResults(ExecResult execResult) {
        if (execResult.getExitValue() != 0 && !this.ignoringNewRules.booleanValue() && this.ignoreRules.size() > 0) {
            this.ignoringNewRules = true;
            this.firstRunOutput = this.output;
            this.subArgs("--extend-ignore=" + String.join((CharSequence)",", this.ignoreRules));
            this.executePythonProcess();
        } else if (execResult.getExitValue() == 0 && this.ignoringNewRules.booleanValue()) {
            log.warn(String.format(IGNORED_RULES_MSG, String.join((CharSequence)", ", this.ignoreRules), this.firstRunOutput));
        } else {
            execResult.assertNormalExitValue();
        }
    }
}

