/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.gradle.python.tasks;

import com.linkedin.gradle.python.PythonExtension;
import com.linkedin.gradle.python.extension.ZipappContainerExtension;
import com.linkedin.gradle.python.util.ExtensionUtils;
import com.linkedin.gradle.python.util.PexFileUtil;
import com.linkedin.gradle.python.util.entrypoint.EntryPointWriter;
import com.linkedin.gradle.python.util.internal.pex.FatPexGenerator;
import com.linkedin.gradle.python.util.internal.zipapp.DefaultTemplateProviderOptions;
import com.linkedin.gradle.python.util.zipapp.DefaultWebappEntryPointTemplateProvider;
import com.linkedin.gradle.python.util.zipapp.EntryPointTemplateProvider;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class BuildWebAppTask
extends DefaultTask {
    private File executable;
    private String entryPoint;
    private List<String> pexOptions = new ArrayList<String>();
    private EntryPointTemplateProvider templateProvider = new DefaultWebappEntryPointTemplateProvider();

    @Input
    @Optional
    public List<String> getPexOptions() {
        return this.pexOptions;
    }

    public void setPexOptions(List<String> pexOptions) {
        this.pexOptions = pexOptions;
    }

    @OutputFile
    public File getExecutable() {
        return this.executable;
    }

    @Input
    public String getEntryPoint() {
        return this.entryPoint;
    }

    @TaskAction
    public void buildWebapp() throws IOException, ClassNotFoundException {
        Project project = this.getProject();
        PythonExtension pythonExtension = ExtensionUtils.getPythonExtension(project);
        ZipappContainerExtension zipappExtension = ExtensionUtils.getPythonComponentExtension(project, ZipappContainerExtension.class);
        if (zipappExtension.isFat()) {
            new FatPexGenerator(project, this.pexOptions).buildEntryPoint(PexFileUtil.createFatPexFilename(this.executable.getName()), this.entryPoint, null);
        } else {
            HashMap<String, String> substitutions = new HashMap<String, String>();
            substitutions.put("entryPoint", this.entryPoint);
            substitutions.put("realPex", PexFileUtil.createThinPexFilename(project.getName()));
            substitutions.put("toolName", project.getName());
            String template = this.templateProvider.retrieveTemplate(new DefaultTemplateProviderOptions(project, pythonExtension, this.entryPoint), false);
            new EntryPointWriter(project, template).writeEntryPoint(this.executable, substitutions);
        }
    }

    public void setExecutable(File executable) {
        this.executable = executable;
    }

    public void setEntryPoint(String entryPoint) {
        this.entryPoint = entryPoint;
    }

    @Input
    @Optional
    public EntryPointTemplateProvider getTemplateProvider() {
        return this.templateProvider;
    }

    public void setTemplateProvider(EntryPointTemplateProvider templateProvider) {
        this.templateProvider = templateProvider;
    }
}

