/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.gradle.python.tasks;

import com.linkedin.gradle.python.PythonExtension;
import com.linkedin.gradle.python.extension.PythonDetails;
import com.linkedin.gradle.python.tasks.exec.ExternalExec;
import com.linkedin.gradle.python.tasks.exec.ProjectExternalExec;
import com.linkedin.gradle.python.tasks.execution.FailureReasonProvider;
import com.linkedin.gradle.python.tasks.execution.TeeOutputContainer;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecResult;
import org.gradle.process.ExecSpec;

public abstract class AbstractPythonMainSourceDefaultTask
extends DefaultTask
implements FailureReasonProvider {
    FileTree sources;
    private List<String> arguments = new ArrayList<String>();
    private List<String> subArguments = new ArrayList<String>();
    private PythonExtension extension;
    private PythonDetails pythonDetails;
    protected String output;
    @Input
    public List<String> additionalArguments = new ArrayList<String>();
    ExternalExec externalExec = new ProjectExternalExec(this.getProject());
    @Input
    public boolean ignoreExitValue = false;
    public OutputStream stdOut = System.out;
    public OutputStream errOut = System.err;

    @InputFiles
    public FileCollection getSourceFiles() {
        ConfigurableFileTree componentFiles = this.getProject().fileTree((Object)this.getComponent().srcDir);
        componentFiles.exclude(this.standardExcludes());
        if (null != this.sources) {
            return this.sources.plus((FileTree)componentFiles);
        }
        return componentFiles;
    }

    public String[] standardExcludes() {
        return new String[]{"**/*.pyc", "**/*.pyo", "**/__pycache__/", "**/*.egg-info/"};
    }

    public PythonExtension getPythonExtension() {
        if (null == this.extension) {
            this.extension = (PythonExtension)this.getProject().getExtensions().getByType(PythonExtension.class);
        }
        return this.extension;
    }

    @Internal
    @Deprecated
    public PythonExtension getComponent() {
        return this.getPythonExtension();
    }

    @Internal
    public PythonDetails getPythonDetails() {
        if (null == this.pythonDetails) {
            this.pythonDetails = this.getComponent().getDetails();
        }
        return this.pythonDetails;
    }

    public void setPythonDetails(PythonDetails pythonDetails) {
        this.pythonDetails = pythonDetails;
    }

    @InputDirectory
    public FileTree getVirtualEnv() {
        ConfigurableFileTree files = this.getProject().fileTree((Object)this.getPythonDetails().getVirtualEnv());
        files.exclude(this.standardExcludes());
        return files;
    }

    public void args(String ... args) {
        this.arguments.addAll(Arrays.asList(args));
    }

    public void args(Collection<String> args) {
        this.arguments.addAll(args);
    }

    public void subArgs(String ... args) {
        this.subArguments.addAll(Arrays.asList(args));
    }

    public void subArgs(Collection<String> args) {
        this.subArguments.addAll(args);
    }

    @TaskAction
    public void executeTask() {
        this.preExecution();
        this.executePythonProcess();
    }

    void executePythonProcess() {
        TeeOutputContainer container = new TeeOutputContainer(this.stdOut, this.errOut);
        ExecResult result = this.externalExec.exec((Action<? super ExecSpec>)((Action)execSpec -> {
            execSpec.environment(this.getComponent().pythonEnvironment);
            execSpec.environment(this.getComponent().pythonEnvironmentDistgradle);
            execSpec.commandLine(new Object[]{this.getPythonDetails().getVirtualEnvInterpreter()});
            execSpec.args(this.arguments);
            execSpec.args(this.subArguments);
            execSpec.args(this.additionalArguments);
            execSpec.setIgnoreExitValue(true);
            container.setOutputs((ExecSpec)execSpec);
            this.configureExecution((ExecSpec)execSpec);
        }));
        this.output = container.getCommandOutput();
        if (!this.ignoreExitValue) {
            result.assertNormalExitValue();
        }
        this.processResults(result);
    }

    public void configureExecution(ExecSpec spec) {
    }

    public void preExecution() {
    }

    public abstract void processResults(ExecResult var1);

    @Override
    @Internal
    public String getReason() {
        return this.output;
    }
}

