/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.gradle.python.plugin;

import com.linkedin.gradle.python.PythonExtension;
import com.linkedin.gradle.python.extension.DeployableExtension;
import com.linkedin.gradle.python.extension.ZipappContainerExtension;
import com.linkedin.gradle.python.plugin.PythonBasePlugin;
import com.linkedin.gradle.python.plugin.PythonPlugin;
import com.linkedin.gradle.python.tasks.BuildWheelsTask;
import com.linkedin.gradle.python.tasks.NoopBuildPexTask;
import com.linkedin.gradle.python.tasks.NoopTask;
import com.linkedin.gradle.python.tasks.PythonContainerTask;
import com.linkedin.gradle.python.util.ApplicationContainer;
import com.linkedin.gradle.python.util.ExtensionUtils;
import com.linkedin.gradle.python.util.StandardTextValues;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.bundling.Compression;
import org.gradle.api.tasks.bundling.Tar;

public class PythonContainerPlugin
extends PythonBasePlugin {
    @Override
    public void applyTo(Project project) {
        project.getPlugins().apply(PythonPlugin.class);
        PythonExtension pythonExtension = ExtensionUtils.getPythonExtension(project);
        ExtensionUtils.maybeCreateWheelExtension(project);
        DeployableExtension deployableExtension = ExtensionUtils.maybeCreateDeployableExtension(project);
        ApplicationContainer applicationContainer = pythonExtension.getApplicationContainer();
        ExtensionUtils.maybeCreate(project, "zipapp", ZipappContainerExtension.class, new Object[0]);
        applicationContainer.addExtensions(project);
        TaskContainer tasks = project.getTasks();
        Task noop = (Task)tasks.findByName("buildPex");
        if (noop == null) {
            noop = tasks.create("buildPex", NoopBuildPexTask.class);
        }
        if (tasks.findByName("assembleContainers") == null) {
            BuildWheelsTask buildWheelsTask = (BuildWheelsTask)tasks.create("buildWheels", BuildWheelsTask.class);
            buildWheelsTask.setInstallFileCollection((FileCollection)project.getConfigurations().getByName("python"));
            buildWheelsTask.dependsOn(new Object[]{tasks.getByName(StandardTextValues.TASK_INSTALL_PROJECT.getValue())});
            BuildWheelsTask projectWheelsTask = (BuildWheelsTask)tasks.create("buildProjectWheel", BuildWheelsTask.class);
            projectWheelsTask.setInstallFileCollection((FileCollection)project.files(new Object[]{project.file((Object)project.getProjectDir())}));
            projectWheelsTask.setEnvironment(pythonExtension.pythonEnvironmentDistgradle);
            projectWheelsTask.dependsOn(new Object[]{tasks.getByName("buildWheels")});
            Task assemble = tasks.create("assembleContainers");
            assemble.dependsOn(new Object[]{noop});
            Tar tar = (Tar)tasks.create("packageDeployable", Tar.class);
            tar.setCompression(Compression.GZIP);
            tar.setBaseName(project.getName());
            tar.setExtension("tar.gz");
            tar.from(new Object[]{deployableExtension.getDeployableBuildDir()});
            tar.dependsOn(new Object[]{assemble});
            project.getArtifacts().add(StandardTextValues.CONFIGURATION_DEFAULT.getValue(), (Object)tar);
        }
        project.afterEvaluate(it -> {
            ApplicationContainer postContainer = pythonExtension.getApplicationContainer();
            if (postContainer == null) {
                throw new IllegalArgumentException("Unknown Python application container: " + pythonExtension.getContainer());
            }
            postContainer.addDependencies(project);
            postContainer.makeTasks(project);
            Task assemble = tasks.getByName("assembleContainers");
            Task parent = tasks.getByName("buildProjectWheel");
            for (Task task : tasks.withType(PythonContainerTask.class)) {
                if (task instanceof NoopTask) {
                    ((NoopTask)task).setSuppressWarning(true);
                }
                assemble.dependsOn(new Object[]{task});
                task.dependsOn(new Object[]{parent});
                if (!(task instanceof NoopTask)) continue;
                ((NoopTask)task).setSuppressWarning(false);
            }
        });
    }
}

