/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.gradle.python.plugin;

import java.util.Map;
import java.util.Objects;
import org.gradle.api.Action;
import org.gradle.api.artifacts.DependencyResolveDetails;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public class PyGradleDependencyResolveDetails
implements Action<DependencyResolveDetails> {
    private static final Logger LOGGER = Logging.getLogger(PyGradleDependencyResolveDetails.class);
    private final Map<String, Map<String, String>> requiredVersions;

    public PyGradleDependencyResolveDetails(Map<String, Map<String, String>> requiredVersions) {
        this.requiredVersions = requiredVersions;
    }

    public void execute(DependencyResolveDetails details) {
        if (this.requiredVersions.containsKey(details.getRequested().getName())) {
            String name = details.getRequested().getName();
            String version = this.requiredVersions.get(name).get("version");
            if (Objects.equals("", version) || null == version) {
                return;
            }
            LOGGER.info("Resolving {} to {}=={} per gradle-python resolution strategy.", new Object[]{name, name, version});
            details.useVersion(version);
        }
    }
}

