/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.gradle.python.extension.internal;

import com.linkedin.gradle.python.exception.MissingInterpreterException;
import com.linkedin.gradle.python.extension.PythonDefaultVersions;
import com.linkedin.gradle.python.extension.PythonDetails;
import com.linkedin.gradle.python.extension.PythonVersion;
import com.linkedin.gradle.python.extension.PythonVersionParser;
import com.linkedin.gradle.python.extension.VirtualEnvironment;
import com.linkedin.gradle.python.extension.internal.DefaultVirtualEnvironment;
import com.linkedin.gradle.python.util.OperatingSystem;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.gradle.api.Project;

public class DefaultPythonDetails
implements PythonDetails,
Serializable {
    private final transient Project project;
    private final File venvOverride;
    private final VirtualEnvironment virtualEnvironment;
    private File activateLink;
    private File pythonInterpreter;
    private String virtualEnvPrompt;
    private PythonVersion pythonVersion;
    private PythonDefaultVersions pythonDefaultVersions;
    private List<File> searchPath;

    public DefaultPythonDetails(Project project, File venvDir) {
        this.project = project;
        this.activateLink = new File(project.getProjectDir(), OperatingSystem.current().getScriptName("activate"));
        this.virtualEnvPrompt = String.format("(%s)", project.getName());
        this.searchPath = OperatingSystem.current().getPath();
        this.venvOverride = venvDir;
        this.virtualEnvironment = new DefaultVirtualEnvironment(this);
        this.pythonDefaultVersions = new PythonDefaultVersions();
    }

    private void updateFromPythonInterpreter() {
        if (this.pythonInterpreter == null || !this.pythonInterpreter.exists()) {
            throw new MissingInterpreterException("Unable to find or execute python");
        }
        this.pythonVersion = PythonVersionParser.parsePythonVersion(this.project, this.pythonInterpreter);
    }

    @Override
    public String getVirtualEnvPrompt() {
        return this.virtualEnvPrompt;
    }

    @Override
    public void setVirtualEnvPrompt(String virtualEnvPrompt) {
        this.virtualEnvPrompt = virtualEnvPrompt;
    }

    @Override
    public File getVirtualEnv() {
        if (this.venvOverride == null) {
            return new File(this.project.getBuildDir(), "venv");
        }
        return this.venvOverride;
    }

    @Override
    public File getVirtualEnvInterpreter() {
        return this.virtualEnvironment.findExecutable("python");
    }

    @Override
    public File getSystemPythonInterpreter() {
        this.findPythonWhenAbsent();
        return this.pythonInterpreter;
    }

    @Override
    public File getActivateLink() {
        return this.activateLink;
    }

    @Override
    public void setActivateLink(File activateLink) {
        this.activateLink = activateLink;
    }

    @Override
    public void prependExecutableDirectory(File file) {
        this.searchPath.add(0, file);
    }

    @Override
    public void appendExecutableDirectory(File file) {
        this.searchPath.add(file);
    }

    @Override
    public void setPythonDefaultVersions(PythonDefaultVersions defaults) {
        this.pythonDefaultVersions = defaults;
    }

    @Override
    public void setPythonDefaultVersions(String defaultPython2, String defaultPython3, Collection<String> allowedVersions) {
        this.pythonDefaultVersions = new PythonDefaultVersions(defaultPython2, defaultPython3, allowedVersions);
    }

    @Override
    public PythonDefaultVersions getPythonDefaultVersions() {
        return this.pythonDefaultVersions;
    }

    @Override
    public void setPythonVersion(String version) {
        version = this.pythonDefaultVersions.normalize(version);
        OperatingSystem operatingSystem = OperatingSystem.current();
        this.pythonInterpreter = operatingSystem.findInPath(this.searchPath, operatingSystem.getExecutableName(String.format("python%s", version)));
        this.updateFromPythonInterpreter();
    }

    public void setPythonInterpreter(PythonVersion pythonVersion, File pythonInterpreter) {
        this.pythonVersion = pythonVersion;
        this.pythonInterpreter = pythonInterpreter;
    }

    @Override
    public void setSystemPythonInterpreter(String path) {
        this.pythonInterpreter = new File(path);
        this.updateFromPythonInterpreter();
    }

    @Override
    public PythonVersion getPythonVersion() {
        this.findPythonWhenAbsent();
        return this.pythonVersion;
    }

    private void findPythonWhenAbsent() {
        if (this.pythonInterpreter == null) {
            OperatingSystem operatingSystem = OperatingSystem.current();
            File python = operatingSystem.findInPath(this.searchPath, operatingSystem.getExecutableName("python"));
            if (python == null) {
                python = new File("/usr/bin/python");
            }
            this.setSystemPythonInterpreter(python.getAbsolutePath());
        }
    }

    @Override
    public VirtualEnvironment getVirtualEnvironment() {
        return this.virtualEnvironment;
    }
}

