/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.gradle.python.extension;

import com.linkedin.gradle.python.wheel.WheelCacheLayer;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.gradle.api.Project;

public class WheelExtension {
    private File wheelCache;
    private File hostLayerWheelCache;
    private File projectLayerWheelCache;
    private Map<WheelCacheLayer, File> layeredCacheMap = new LinkedHashMap<WheelCacheLayer, File>();

    public WheelExtension(Project project) {
        this.wheelCache = new File(project.getBuildDir(), "wheel-cache");
    }

    public File getWheelCache() {
        return this.wheelCache;
    }

    public void setWheelCache(File wheelCache) {
        this.wheelCache = wheelCache;
    }

    public Optional<File> getHostLayerWheelCache() {
        return Optional.ofNullable(this.hostLayerWheelCache);
    }

    public void setHostLayerWheelCache(File hostLayerWheelCache) {
        this.hostLayerWheelCache = hostLayerWheelCache;
        this.layeredCacheMap.put(WheelCacheLayer.HOST_LAYER, this.hostLayerWheelCache);
    }

    public Optional<File> getProjectLayerWheelCache() {
        return Optional.ofNullable(this.projectLayerWheelCache);
    }

    public void setProjectLayerWheelCache(File projectLayerWheelCache) {
        this.projectLayerWheelCache = projectLayerWheelCache;
        this.layeredCacheMap.put(WheelCacheLayer.PROJECT_LAYER, this.projectLayerWheelCache);
    }

    public Map<WheelCacheLayer, File> getLayeredCacheMap() {
        return this.layeredCacheMap;
    }
}

