/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.gradle.python.extension;

import com.linkedin.gradle.python.extension.PythonVersion;
import java.io.Serializable;
import java.util.Collection;
import java.util.TreeSet;
import org.gradle.api.GradleException;

public class PythonDefaultVersions
implements Serializable {
    private final String defaultPython2Version;
    private final String defaultPython3Version;
    private final Collection<String> allowedVersions;

    public PythonDefaultVersions(String defaultPython2, String defaultPython3, Collection<String> allowedVersions) {
        this.defaultPython2Version = defaultPython2;
        this.defaultPython3Version = defaultPython3;
        this.allowedVersions = allowedVersions;
    }

    public PythonDefaultVersions(Collection<String> allowedVersions) {
        this.defaultPython2Version = "2.7";
        this.defaultPython3Version = "3.7";
        this.allowedVersions = allowedVersions;
    }

    public PythonDefaultVersions(String defaultPython2, String defaultPython3) {
        this(defaultPython2, defaultPython3, new TreeSet<String>());
    }

    public PythonDefaultVersions() {
        this(new TreeSet<String>());
    }

    public String normalize(String version) {
        if (version.equals("2")) {
            return this.defaultPython2Version;
        }
        if (version.equals("3")) {
            return this.defaultPython3Version;
        }
        if (this.allowedVersions.isEmpty()) {
            return version;
        }
        if (!this.allowedVersions.contains(new PythonVersion(version).getPythonMajorMinor())) {
            throw new GradleException("Python " + version + " is not allowed; choose from " + this.allowedVersions + "\nSee https://github.com/linkedin/pygradle/blob/master/docs/plugins/python.md#default-and-allowed-python-version");
        }
        return version;
    }
}

