/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.gradle.python.checkstyle;

import com.linkedin.gradle.python.checkstyle.model.FileStyleViolationsContainer;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CheckStyleXmlReporter {
    private final FileStyleViolationsContainer violationContainer;

    public CheckStyleXmlReporter(FileStyleViolationsContainer container) {
        this.violationContainer = container;
    }

    public String generateXml() {
        DocumentBuilderFactory icFactory = DocumentBuilderFactory.newInstance();
        try {
            Document document = icFactory.newDocumentBuilder().newDocument();
            Element rootNode = document.createElement("checkstyle");
            this.violationContainer.getViolations().forEach(fileStyleViolation -> {
                Element fileNode = document.createElement("file");
                fileNode.setAttribute("name", fileStyleViolation.getFilename());
                fileStyleViolation.getViolations().forEach(violation -> {
                    Element error = document.createElement("error");
                    violation.createCheckstyleMap().forEach((key, value) -> error.setAttribute((String)key, value.toString()));
                    fileNode.appendChild(error);
                });
                rootNode.appendChild(fileNode);
            });
            document.appendChild(rootNode);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(document);
            StringWriter stringWriter = new StringWriter();
            StreamResult console = new StreamResult(stringWriter);
            transformer.transform(source, console);
            stringWriter.close();
            return stringWriter.toString();
        }
        catch (Exception e) {
            throw new CheckstyleException(e);
        }
    }

    private static class CheckstyleException
    extends RuntimeException {
        CheckstyleException(Throwable t) {
            super(t);
        }
    }
}

