/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.theme.speedwell.site.initializer.internal;

import com.liferay.account.settings.AccountEntryGroupSettings;
import com.liferay.commerce.configuration.CommerceAccountGroupServiceConfiguration;
import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.service.CommerceCurrencyLocalService;
import com.liferay.commerce.initializer.util.AssetCategoriesImporter;
import com.liferay.commerce.initializer.util.BlogsImporter;
import com.liferay.commerce.initializer.util.CPDefinitionsImporter;
import com.liferay.commerce.initializer.util.CPOptionCategoriesImporter;
import com.liferay.commerce.initializer.util.CPOptionsImporter;
import com.liferay.commerce.initializer.util.CPSpecificationOptionsImporter;
import com.liferay.commerce.initializer.util.CommerceAccountsImporter;
import com.liferay.commerce.initializer.util.CommerceDiscountsImporter;
import com.liferay.commerce.initializer.util.CommerceInventoryWarehousesImporter;
import com.liferay.commerce.initializer.util.CommercePriceEntriesImporter;
import com.liferay.commerce.initializer.util.CommercePriceListsImporter;
import com.liferay.commerce.initializer.util.CommerceUsersImporter;
import com.liferay.commerce.initializer.util.DDMFormImporter;
import com.liferay.commerce.initializer.util.DLImporter;
import com.liferay.commerce.initializer.util.JournalArticleImporter;
import com.liferay.commerce.initializer.util.KBArticleImporter;
import com.liferay.commerce.initializer.util.OrganizationImporter;
import com.liferay.commerce.initializer.util.PortletSettingsImporter;
import com.liferay.commerce.inventory.model.CommerceInventoryWarehouse;
import com.liferay.commerce.media.CommerceCatalogDefaultImage;
import com.liferay.commerce.model.CommerceShippingEngine;
import com.liferay.commerce.model.CommerceShippingMethod;
import com.liferay.commerce.product.importer.CPFileImporter;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPOption;
import com.liferay.commerce.product.model.CommerceCatalog;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CPDefinitionLinkLocalService;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.commerce.product.service.CPMeasurementUnitLocalService;
import com.liferay.commerce.product.service.CommerceCatalogLocalService;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.service.CommerceShippingMethodLocalService;
import com.liferay.commerce.shipping.engine.fixed.service.CommerceShippingFixedOptionLocalService;
import com.liferay.commerce.theme.speedwell.site.initializer.internal.dependencies.resolver.SpeedwellDependencyResolverUtil;
import com.liferay.commerce.util.AccountEntryAllowedTypesUtil;
import com.liferay.commerce.util.CommerceAccountRoleHelper;
import com.liferay.commerce.util.CommerceShippingEngineRegistry;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.model.ThemeSetting;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ThemeLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.settings.FallbackKeysSettingsUtil;
import com.liferay.portal.kernel.settings.GroupServiceSettingsLocator;
import com.liferay.portal.kernel.settings.ModifiableSettings;
import com.liferay.portal.kernel.settings.Settings;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.TempFileEntryUtil;
import com.liferay.portal.search.capabilities.SearchCapabilities;
import com.liferay.site.exception.InitializationException;
import com.liferay.site.initializer.SiteInitializer;
import java.io.File;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.ServletContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(property={"site.initializer.key=speedwell-initializer"}, service={SiteInitializer.class})
public class SpeedwellSiteInitializer
implements SiteInitializer {
    public static final String KEY = "speedwell-initializer";
    private static final String _SPEEDWELL_THEME_ID = "speedwell_WAR_speedwelltheme";
    private static final Log _log = LogFactoryUtil.getLog(SpeedwellSiteInitializer.class);
    @Reference
    private AccountEntryGroupSettings _accountEntryGroupSettings;
    @Reference
    private AssetCategoriesImporter _assetCategoriesImporter;
    @Reference
    private BlogsImporter _blogsImporter;
    @Reference
    private CommerceAccountRoleHelper _commerceAccountRoleHelper;
    @Reference
    private CommerceAccountsImporter _commerceAccountsImporter;
    @Reference
    private CommerceCatalogDefaultImage _commerceCatalogDefaultImage;
    @Reference
    private CommerceCatalogLocalService _commerceCatalogLocalService;
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceCurrencyLocalService _commerceCurrencyLocalService;
    @Reference
    private CommerceDiscountsImporter _commerceDiscountsImporter;
    @Reference
    private CommerceInventoryWarehousesImporter _commerceInventoryWarehousesImporter;
    @Reference
    private CommercePriceEntriesImporter _commercePriceEntriesImporter;
    @Reference
    private CommercePriceListsImporter _commercePriceListsImporter;
    @Reference
    private CommerceShippingEngineRegistry _commerceShippingEngineRegistry;
    @Reference
    private CommerceShippingFixedOptionLocalService _commerceShippingFixedOptionLocalService;
    @Reference
    private CommerceShippingMethodLocalService _commerceShippingMethodLocalService;
    @Reference
    private CommerceUsersImporter _commerceUsersImporter;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private CPDefinitionLinkLocalService _cpDefinitionLinkLocalService;
    @Reference
    private CPDefinitionLocalService _cpDefinitionLocalService;
    private Map<String, CPDefinition> _cpDefinitions;
    @Reference
    private CPDefinitionsImporter _cpDefinitionsImporter;
    @Reference
    private CPFileImporter _cpFileImporter;
    @Reference
    private CPMeasurementUnitLocalService _cpMeasurementUnitLocalService;
    @Reference
    private CPOptionCategoriesImporter _cpOptionCategoriesImporter;
    @Reference
    private CPOptionsImporter _cpOptionsImporter;
    @Reference
    private CPSpecificationOptionsImporter _cpSpecificationOptionsImporter;
    @Reference
    private DDMFormImporter _ddmFormImporter;
    @Reference
    private DLFileEntryLocalService _dlFileEntryLocalService;
    @Reference
    private DLImporter _dlImporter;
    @Reference
    private com.liferay.portal.kernel.util.File _file;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private JournalArticleImporter _journalArticleImporter;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private KBArticleImporter _kbArticleImporter;
    @Reference
    private Language _language;
    @Reference
    private OrganizationImporter _organizationImporter;
    @Reference
    private PortletSettingsImporter _portletSettingsImporter;
    @Reference
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private SearchCapabilities _searchCapabilities;
    @Reference(target="(osgi.web.symbolicname=com.liferay.commerce.theme.speedwell.site.initializer)")
    private ServletContext _servletContext;
    @Reference
    private ThemeLocalService _themeLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public String getDescription(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, this.getClass());
        return this._language.get(resourceBundle, "speedwell-description");
    }

    public String getKey() {
        return KEY;
    }

    public String getName(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, this.getClass());
        return this._language.get(resourceBundle, "speedwell");
    }

    public String getThumbnailSrc() {
        return this._servletContext.getContextPath() + "/images/thumbnail.png";
    }

    public void init() {
        this._cpDefinitions = new HashMap<String, CPDefinition>();
    }

    public void initialize(long groupId) throws InitializationException {
        try {
            ServiceContext serviceContext = this._getServiceContext(groupId);
            this._cpFileImporter.updateLookAndFeel(_SPEEDWELL_THEME_ID, false, serviceContext);
            this._updateLogo(serviceContext);
            this._createRoles(serviceContext);
            CommerceCatalog commerceCatalog = this._createCatalog(serviceContext);
            long catalogGroupId = commerceCatalog.getGroupId();
            CommerceChannel commerceChannel = this._createChannel(commerceCatalog, serviceContext);
            this._configureB2CSite(commerceChannel.getGroup(), serviceContext);
            this._createLayouts(serviceContext);
            this._importAssetCategories(serviceContext);
            this._importBlogsEntries(serviceContext);
            this._importCommerceDiscounts(serviceContext);
            this._importCPOptionCategories(catalogGroupId, serviceContext);
            this._importCPSpecificationOptions(catalogGroupId, serviceContext);
            List<CommerceInventoryWarehouse> commerceInventoryWarehouses = this._importCommerceInventoryWarehouses(serviceContext);
            this._importCPOptions(catalogGroupId, serviceContext);
            this._importCommerceOrganizations(serviceContext);
            this._importCommerceAccounts(serviceContext);
            List<CPDefinition> cpDefinitions = this._importCPDefinitions(catalogGroupId, commerceChannel.getCommerceChannelId(), commerceInventoryWarehouses, serviceContext);
            this._importRelatedProducts(cpDefinitions, serviceContext);
            this._importCommercePriceLists(catalogGroupId, serviceContext);
            this._importCommercePriceEntries(catalogGroupId, serviceContext);
            this._importBaseCommercePriceListEntries(commerceCatalog, cpDefinitions);
            this._importCommerceUsers(serviceContext);
            this._importDDMForms(serviceContext);
            this._importDLFileEntries(serviceContext);
            this._importJournalArticles(serviceContext);
            this._importKBArticles(serviceContext);
            this._importThemePortletSettings(serviceContext);
            this._importPortletSettings(serviceContext);
            this._fixDLFileEntryPermissions(groupId);
            this._setCommerceShippingMethod(commerceChannel.getGroupId(), "fixed", serviceContext);
            int catalogCPDefinitionsCount = this._cpDefinitionLocalService.getCPDefinitionsCount(catalogGroupId, -1);
            if (catalogCPDefinitionsCount > 0) {
                this._setDefaultCatalogImage(catalogGroupId, serviceContext);
            } else {
                this._commerceCatalogLocalService.deleteCommerceCatalog(commerceCatalog);
            }
            this._setThemeSettings(serviceContext);
        }
        catch (InitializationException initializationException) {
            throw initializationException;
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            throw new InitializationException((Throwable)exception);
        }
    }

    public boolean isActive(long companyId) {
        if (!this._searchCapabilities.isCommerceSupported()) {
            return false;
        }
        Theme theme = this._themeLocalService.fetchTheme(companyId, _SPEEDWELL_THEME_ID);
        if (theme == null) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"speedwell_WAR_speedwelltheme is not registered");
            }
            return false;
        }
        return true;
    }

    @Activate
    protected void activate() {
        this.init();
    }

    @Deactivate
    protected void deactivate() {
        this._cpDefinitions = null;
    }

    private void _configureB2CSite(Group group, ServiceContext serviceContext) throws Exception {
        group.setType(1);
        group.setManualMembership(true);
        group.setMembershipRestriction(0);
        group = this._groupLocalService.updateGroup(group);
        this._commerceCurrencyLocalService.importDefaultValues(true, serviceContext);
        this._cpMeasurementUnitLocalService.importDefaultValues(serviceContext);
        this._commerceAccountRoleHelper.checkCommerceAccountRoles(serviceContext);
        Settings settings = FallbackKeysSettingsUtil.getSettings((SettingsLocator)new GroupServiceSettingsLocator(group.getGroupId(), "com.liferay.commerce.account"));
        ModifiableSettings modifiableSettings = settings.getModifiableSettings();
        modifiableSettings.setValue("commerceSiteType", String.valueOf(0));
        modifiableSettings.store();
        this._accountEntryGroupSettings.setAllowedTypes(serviceContext.getScopeGroupId(), this._getAllowedTypes(group.getGroupId()));
    }

    private CommerceCatalog _createCatalog(ServiceContext serviceContext) throws Exception {
        Group group = serviceContext.getScopeGroup();
        CommerceCurrency commerceCurrency = this._commerceCurrencyLocalService.fetchPrimaryCommerceCurrency(serviceContext.getCompanyId());
        return this._commerceCatalogLocalService.addCommerceCatalog("", group.getName(serviceContext.getLanguageId()), commerceCurrency.getCode(), serviceContext.getLanguageId(), serviceContext);
    }

    private CommerceChannel _createChannel(CommerceCatalog commerceCatalog, ServiceContext serviceContext) throws Exception {
        Group group = serviceContext.getScopeGroup();
        return this._commerceChannelLocalService.addCommerceChannel("", 0L, group.getGroupId(), group.getName(serviceContext.getLanguageId()) + " Portal", "site", null, commerceCatalog.getCommerceCurrencyCode(), serviceContext);
    }

    private void _createLayouts(ServiceContext serviceContext) throws Exception {
        this._cpFileImporter.cleanLayouts(serviceContext);
        JSONArray jsonArray = this._jsonFactory.createJSONArray(SpeedwellDependencyResolverUtil.getJSON("layouts.json"));
        this._cpFileImporter.createLayouts(jsonArray, SpeedwellDependencyResolverUtil.getImageClassLoader(), SpeedwellDependencyResolverUtil.getImageDependencyPath(), serviceContext);
    }

    private void _createRoles(ServiceContext serviceContext) throws Exception {
        this._cpFileImporter.createRoles(this._getJSONArray("roles.json"), serviceContext);
        this._updateUserRole(serviceContext);
    }

    private void _fixDLFileEntryPermissions(long groupId) throws PortalException {
        List dlFileEntries = this._dlFileEntryLocalService.getFileEntries(groupId, 0L);
        if (dlFileEntries.isEmpty()) {
            return;
        }
        Group group = this._groupLocalService.getGroup(groupId);
        long companyId = group.getCompanyId();
        for (DLFileEntry dlFileEntry : dlFileEntries) {
            Role role = this._roleLocalService.getRole(companyId, "Guest");
            this._resourcePermissionLocalService.setResourcePermissions(companyId, dlFileEntry.getModelClassName(), 4, String.valueOf(dlFileEntry.getPrimaryKey()), role.getRoleId(), new String[]{"VIEW"});
        }
    }

    private String[] _getAllowedTypes(long commerceChannelGroupId) throws Exception {
        CommerceAccountGroupServiceConfiguration commerceAccountGroupServiceConfiguration = (CommerceAccountGroupServiceConfiguration)this._configurationProvider.getConfiguration(CommerceAccountGroupServiceConfiguration.class, (SettingsLocator)new GroupServiceSettingsLocator(commerceChannelGroupId, "com.liferay.commerce.account"));
        return AccountEntryAllowedTypesUtil.getAllowedTypes((int)commerceAccountGroupServiceConfiguration.commerceSiteType());
    }

    private CPDefinition _getCPDefinitionByName(String name) {
        return this._cpDefinitions.get(name);
    }

    private long[] _getCProductIds(JSONArray jsonArray) {
        ArrayList<Long> cProductIdsList = new ArrayList<Long>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            CPDefinition cpDefinitionEntry = this._getCPDefinitionByName(jsonArray.getString(i));
            cProductIdsList.add(cpDefinitionEntry.getCProductId());
        }
        return ArrayUtil.toLongArray(cProductIdsList);
    }

    private JSONArray _getJSONArray(String name) throws Exception {
        return this._jsonFactory.createJSONArray(SpeedwellDependencyResolverUtil.getJSON(name));
    }

    private JSONObject _getJSONObject(String name) throws Exception {
        return this._jsonFactory.createJSONObject(SpeedwellDependencyResolverUtil.getJSON(name));
    }

    private ServiceContext _getServiceContext(long groupId) throws PortalException {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        Group group = this._groupLocalService.getGroup(groupId);
        serviceContext.setCompanyId(group.getCompanyId());
        serviceContext.setLanguageId(this._language.getLanguageId(LocaleUtil.getSiteDefault()));
        serviceContext.setScopeGroupId(groupId);
        User user = this._userLocalService.getUser(PrincipalThreadLocal.getUserId());
        serviceContext.setTimeZone(user.getTimeZone());
        serviceContext.setUserId(user.getUserId());
        return serviceContext;
    }

    private void _importAssetCategories(ServiceContext serviceContext) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Importing Asset Categories...");
        }
        Group group = serviceContext.getScopeGroup();
        Company company = this._companyLocalService.getCompany(serviceContext.getCompanyId());
        this._assetCategoriesImporter.importAssetCategories(this._getJSONArray("categories.json"), group.getName(serviceContext.getLocale()), SpeedwellDependencyResolverUtil.getImageClassLoader(), SpeedwellDependencyResolverUtil.getImageDependencyPath(), company.getGroupId(), serviceContext.getUserId(), true);
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Asset Categories successfully imported");
        }
    }

    private void _importBaseCommercePriceListEntries(CommerceCatalog commerceCatalog, List<CPDefinition> cpDefinitions) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Importing base commerce price list entries...");
        }
        this._commercePriceEntriesImporter.importBaseCommercePriceListEntries(commerceCatalog, cpDefinitions, "price-list");
        this._commercePriceEntriesImporter.importBaseCommercePriceListEntries(commerceCatalog, cpDefinitions, "promotion");
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Base commerce price list entries successfully imported");
        }
    }

    private void _importBlogsEntries(ServiceContext serviceContext) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Importing Blogs Entries...");
        }
        this._blogsImporter.importBlogsEntries(this._getJSONArray("blogs.json"), SpeedwellDependencyResolverUtil.getImageClassLoader(), SpeedwellDependencyResolverUtil.getImageDependencyPath(), serviceContext.getScopeGroupId(), serviceContext.getUserId());
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Blogs Entries successfully imported");
        }
    }

    private void _importCommerceAccounts(ServiceContext serviceContext) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Importing Commerce Accounts...");
        }
        this._commerceAccountsImporter.importCommerceAccounts(this._getJSONArray("accounts.json"), SpeedwellDependencyResolverUtil.getImageClassLoader(), SpeedwellDependencyResolverUtil.getDependenciesPath(), serviceContext.getScopeGroupId(), serviceContext.getUserId());
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Commerce Accounts successfully imported");
        }
    }

    private void _importCommerceDiscounts(ServiceContext serviceContext) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Importing Commerce Discounts...");
        }
        this._commerceDiscountsImporter.importCommerceDiscounts(this._getJSONArray("discounts.json"), serviceContext.getScopeGroupId(), serviceContext.getUserId());
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Commerce Discounts successfully imported");
        }
    }

    private List<CommerceInventoryWarehouse> _importCommerceInventoryWarehouses(ServiceContext serviceContext) throws Exception {
        return this._commerceInventoryWarehousesImporter.importCommerceInventoryWarehouses(this._getJSONArray("warehouses.json"), serviceContext.getScopeGroupId(), serviceContext.getUserId());
    }

    private void _importCommerceOrganizations(ServiceContext serviceContext) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Importing Organizations...");
        }
        this._organizationImporter.importOrganizations(this._getJSONArray("organizations.json"), serviceContext.getScopeGroupId(), serviceContext.getUserId());
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Organizations successfully imported");
        }
    }

    private void _importCommercePriceEntries(long catalogGroupId, ServiceContext serviceContext) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Importing Commerce Price Entries...");
        }
        this._commercePriceEntriesImporter.importCommercePriceEntries(this._getJSONArray("price-entries.json"), catalogGroupId, serviceContext.getUserId());
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Commerce Price Entries successfully imported");
        }
    }

    private void _importCommercePriceLists(long catalogGroupId, ServiceContext serviceContext) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Importing Commerce Price Lists...");
        }
        this._commercePriceListsImporter.importCommercePriceLists(catalogGroupId, this._getJSONArray("price-lists.json"), serviceContext.getScopeGroupId(), serviceContext.getUserId());
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Commerce Price Lists successfully imported");
        }
    }

    private void _importCommerceUsers(ServiceContext serviceContext) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Importing Commerce Users...");
        }
        this._commerceUsersImporter.importCommerceUsers(this._getJSONArray("users.json"), SpeedwellDependencyResolverUtil.getImageClassLoader(), SpeedwellDependencyResolverUtil.getImageDependencyPath(), serviceContext.getScopeGroupId(), serviceContext.getUserId());
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Commerce Users successfully imported");
        }
    }

    private List<CPDefinition> _importCPDefinitions(long catalogGroupId, long commerceChannelId, List<CommerceInventoryWarehouse> commerceInventoryWarehouses, ServiceContext serviceContext) throws Exception {
        Group group = serviceContext.getScopeGroup();
        JSONArray jsonArray = this._getJSONArray("products.json");
        long[] commerceInventoryWarehouseIds = ListUtil.toLongArray(commerceInventoryWarehouses, (Accessor)CommerceInventoryWarehouse.COMMERCE_INVENTORY_WAREHOUSE_ID_ACCESSOR);
        return this._cpDefinitionsImporter.importCPDefinitions(jsonArray, group.getName(serviceContext.getLocale()), catalogGroupId, commerceChannelId, commerceInventoryWarehouseIds, SpeedwellDependencyResolverUtil.getImageClassLoader(), SpeedwellDependencyResolverUtil.getImageDependencyPath(), serviceContext.getScopeGroupId(), serviceContext.getUserId());
    }

    private void _importCPOptionCategories(long catalogGroupId, ServiceContext serviceContext) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Importing Commerce Product Option Categories...");
        }
        this._cpOptionCategoriesImporter.importCPOptionCategories(this._getJSONArray("option-categories.json"), catalogGroupId, serviceContext.getUserId());
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Commerce Product Option Categories successfully imported");
        }
    }

    private List<CPOption> _importCPOptions(long catalogGroupId, ServiceContext serviceContext) throws Exception {
        return this._cpOptionsImporter.importCPOptions(this._getJSONArray("options.json"), catalogGroupId, serviceContext.getUserId());
    }

    private void _importCPSpecificationOptions(long catalogGroupId, ServiceContext serviceContext) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Importing Commerce Product Specification Options...");
        }
        this._cpSpecificationOptionsImporter.importCPSpecificationOptions(this._getJSONArray("specification-options.json"), catalogGroupId, serviceContext.getUserId());
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Commerce Product Specification Options successfully imported");
        }
    }

    private void _importDDMForms(ServiceContext serviceContext) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Importing DDM Forms...");
        }
        this._ddmFormImporter.importDDMForms(this._getJSONArray("forms.json"), serviceContext.getScopeGroupId(), serviceContext.getUserId());
        if (_log.isInfoEnabled()) {
            _log.info((Object)"DDM Forms successfully imported");
        }
    }

    private void _importDLFileEntries(ServiceContext serviceContext) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Importing DL File Entries...");
        }
        this._dlImporter.importDocuments(this._getJSONArray("dl-file-entries.json"), SpeedwellDependencyResolverUtil.getDocumentsClassLoader(), SpeedwellDependencyResolverUtil.getDocumentsDependencyPath(), serviceContext.getScopeGroupId(), serviceContext.getUserId());
        if (_log.isInfoEnabled()) {
            _log.info((Object)"DL File Entries successfully imported");
        }
    }

    private void _importJournalArticles(ServiceContext serviceContext) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Importing Journal Articles...");
        }
        this._journalArticleImporter.importJournalArticles(this._getJSONArray("journal-articles.json"), SpeedwellDependencyResolverUtil.getDocumentsClassLoader(), SpeedwellDependencyResolverUtil.getDependenciesPath() + "journal_articles/", serviceContext.getScopeGroupId(), serviceContext.getUserId());
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Journal Articles successfully imported");
        }
    }

    private void _importKBArticles(ServiceContext serviceContext) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Importing KB Articles...");
        }
        this._kbArticleImporter.importKBArticles(this._getJSONArray("kb-articles.json"), serviceContext.getScopeGroupId(), serviceContext.getUserId());
        if (_log.isInfoEnabled()) {
            _log.info((Object)"KB Articles successfully imported");
        }
    }

    private void _importPortletSettings(ServiceContext serviceContext) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Importing portlet settings...");
        }
        JSONArray jsonArray = this._getJSONArray("portlet-settings.json");
        Company company = this._companyLocalService.getCompany(serviceContext.getCompanyId());
        this._portletSettingsImporter.importPortletSettings(jsonArray, SpeedwellDependencyResolverUtil.getDisplayTemplatesClassLoader(), SpeedwellDependencyResolverUtil.getDisplayTemplatesDependencyPath(), serviceContext.getScopeGroupId(), company.getGroupId(), serviceContext.getUserId());
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Portlet settings successfully imported");
        }
    }

    private void _importRelatedProducts(JSONArray jsonArray, ServiceContext serviceContext) throws Exception {
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject productJSONObject = jsonArray.getJSONObject(i);
            JSONArray relatedProductsJSONArray = productJSONObject.getJSONArray("RelatedProducts");
            if (relatedProductsJSONArray == null) continue;
            String name = productJSONObject.getString("Name");
            CPDefinition cpDefinition = this._getCPDefinitionByName(name);
            this._cpDefinitionLinkLocalService.updateCPDefinitionLinkCProductIds(cpDefinition.getCPDefinitionId(), this._getCProductIds(relatedProductsJSONArray), "related", serviceContext);
        }
    }

    private void _importRelatedProducts(List<CPDefinition> cpDefinitions, ServiceContext serviceContext) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Importing Related Products...");
        }
        for (CPDefinition cpDefinition : cpDefinitions) {
            this._cpDefinitions.put(cpDefinition.getName(serviceContext.getLanguageId()), cpDefinition);
        }
        this._importRelatedProducts(this._getJSONArray("products.json"), serviceContext);
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Related Products successfully imported");
        }
    }

    private void _importThemePortletSettings(ServiceContext serviceContext) throws Exception {
        JSONArray jsonArray = this._getJSONArray("theme-portlet-settings.json");
        Company company = this._companyLocalService.getCompany(serviceContext.getCompanyId());
        this._portletSettingsImporter.importPortletSettings(jsonArray, SpeedwellDependencyResolverUtil.getDisplayTemplatesClassLoader(), SpeedwellDependencyResolverUtil.getDisplayTemplatesDependencyPath(), serviceContext.getScopeGroupId(), company.getGroupId(), serviceContext.getUserId());
    }

    private void _setCommerceShippingMethod(long groupId, String shippingMethod, ServiceContext serviceContext) throws PortalException {
        Locale locale = serviceContext.getLocale();
        CommerceShippingEngine commerceShippingEngine = this._commerceShippingEngineRegistry.getCommerceShippingEngine(shippingMethod);
        Map<Locale, String> nameMap = Collections.singletonMap(locale, commerceShippingEngine.getName(locale));
        Map<Locale, String> descriptionMap = Collections.singletonMap(locale, commerceShippingEngine.getDescription(locale));
        CommerceShippingMethod commerceShippingMethod = this._commerceShippingMethodLocalService.addCommerceShippingMethod(serviceContext.getUserId(), groupId, nameMap, descriptionMap, true, shippingMethod, null, 0.0, "");
        this._setCommerceShippingOption(commerceShippingMethod, "Standard Delivery", "", BigDecimal.valueOf(15L), serviceContext);
        this._setCommerceShippingOption(commerceShippingMethod, "Expedited Delivery", "", BigDecimal.valueOf(25L), serviceContext);
    }

    private void _setCommerceShippingOption(CommerceShippingMethod commerceShippingMethod, String name, String description, BigDecimal price, ServiceContext serviceContext) throws PortalException {
        Map<Locale, String> nameMap = Collections.singletonMap(serviceContext.getLocale(), name);
        Map<Locale, String> descriptionMap = Collections.singletonMap(serviceContext.getLocale(), description);
        this._commerceShippingFixedOptionLocalService.addCommerceShippingFixedOption(serviceContext.getUserId(), commerceShippingMethod.getGroupId(), commerceShippingMethod.getCommerceShippingMethodId(), price, descriptionMap, null, nameMap, 0.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _setDefaultCatalogImage(long catalogGroupId, ServiceContext serviceContext) throws Exception {
        ClassLoader classLoader = SpeedwellDependencyResolverUtil.getImageClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(SpeedwellDependencyResolverUtil.getImageDependencyPath() + "Speedwell_ProductImage_Default.png");
        File file = null;
        try {
            file = this._file.createTempFile(inputStream);
            String mimeType = MimeTypesUtil.getContentType((File)file);
            FileEntry fileEntry = TempFileEntryUtil.addTempFileEntry((long)catalogGroupId, (long)serviceContext.getUserId(), (String)SpeedwellSiteInitializer.class.getName(), (String)file.getName(), (File)file, (String)mimeType);
            this._commerceCatalogDefaultImage.updateDefaultCatalogFileEntryId(catalogGroupId, fileEntry.getFileEntryId());
        }
        finally {
            if (file != null) {
                this._file.delete(file);
            }
        }
    }

    private void _setThemeSettings(ServiceContext serviceContext) throws Exception {
        JSONObject themeSettingsJSONObject = this._getJSONObject("theme-settings.json");
        Iterator iterator = themeSettingsJSONObject.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            String value = themeSettingsJSONObject.getString(key);
            this._updateThemeSetting(key, value, serviceContext);
        }
    }

    private void _updateLogo(ServiceContext serviceContext) throws Exception {
        ClassLoader classLoader = SpeedwellDependencyResolverUtil.getImageClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(SpeedwellDependencyResolverUtil.getImageDependencyPath() + "Speedwell_Logo.png");
        File file = this._file.createTempFile(inputStream);
        this._cpFileImporter.updateLogo(file, false, true, serviceContext);
        this._cpFileImporter.updateLogo(file, true, true, serviceContext);
    }

    private void _updateThemeSetting(String key, String value, ServiceContext serviceContext) {
        Theme theme = this._themeLocalService.fetchTheme(serviceContext.getCompanyId(), _SPEEDWELL_THEME_ID);
        if (theme == null) {
            return;
        }
        Map configurableSettings = theme.getConfigurableSettings();
        ThemeSetting themeSetting = (ThemeSetting)configurableSettings.get(key);
        themeSetting.setValue(value);
    }

    private void _updateUserRole(ServiceContext serviceContext) throws Exception {
        Role role = this._roleLocalService.fetchRole(serviceContext.getCompanyId(), "User");
        this._resourcePermissionLocalService.addResourcePermission(serviceContext.getCompanyId(), "com.liferay.commerce.product", 3, String.valueOf(0L), role.getRoleId(), "VIEW_PRICE");
    }
}

