/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class WhitespaceAroundGenericsCheck
extends BaseCheck {
    private static final String _MSG_MISSING_WHITESPACE = "whitespace.missing";
    private static final String _MSG_REDUNDANT_WHITESPACE = "whitespace.redundant";

    public int[] getDefaultTokens() {
        return new int[]{173, 172};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        char c;
        if (!this.hasParentWithTokenType(detailAST, 13)) {
            return;
        }
        String line = this.getLine(detailAST.getLineNo() - 1);
        if (detailAST.getType() == 173) {
            if (detailAST.getColumnNo() + 1 >= line.length()) {
                return;
            }
            char c2 = line.charAt(detailAST.getColumnNo() + 1);
            if (c2 != ')' && c2 != ',' && c2 != '.' && c2 != '>' && c2 != '[' && c2 != ' ') {
                this.log(detailAST, _MSG_MISSING_WHITESPACE, new Object[]{detailAST.getText()});
            }
        } else if (!this.isAtLineStart(detailAST, line) && (c = line.charAt(detailAST.getColumnNo() - 1)) == ' ') {
            this.log(detailAST, _MSG_REDUNDANT_WHITESPACE, new Object[]{detailAST.getText()});
        }
    }
}

