/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class LineBreakAfterCommaCheck
extends BaseCheck {
    private static final String _MSG_INCORRECT_LINE_BREAK = "line.break.incorrect";

    public int[] getDefaultTokens() {
        return new int[]{74};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        String line = this.getLine(detailAST.getLineNo() - 1);
        if (this.isAtLineEnd(detailAST, line)) {
            return;
        }
        int lineNo = detailAST.getLineNo();
        if (lineNo != this.getStartLineNumber(detailAST.getPreviousSibling()) || lineNo != this.getEndLineNumber(detailAST.getNextSibling())) {
            String s = StringUtil.trim(line.substring(0, detailAST.getColumnNo() + 1));
            this.log(lineNo, _MSG_INCORRECT_LINE_BREAK, new Object[]{s});
        }
    }
}

