/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConstantNameCheck
extends BaseCheck {
    private static final String _CAMEL_CASE_REGEX = "^[a-z0-9][a-zA-Z0-9]*$";
    private static final String _CAMEL_CASE_TYPE_NAMES_KEY = "camelCaseTypeNames";
    private static final String _CONSTANT_NAME_REGEX = "^[a-zA-Z0-9][_a-zA-Z0-9]*$";
    private static final String _IMMUTABLE_FIELD_TYPES_KEY = "immutableFieldTypes";
    private static final String _MSG_INVALID_CONSTANT_NAME = "name.invalidConstantPattern";
    private static final String _MSG_INVALID_CONSTANT_TYPE_NAME = "name.invalidConstantTypePattern";
    private static final String _UPPER_CASE_REGEX = "^[A-Z0-9][_A-Z0-9]*$";

    public int[] getDefaultTokens() {
        return new int[]{10};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        this._checkConstantName(detailAST);
    }

    private void _checkConstantName(DetailAST detailAST) {
        DetailAST modifiersDetailAST = detailAST.findFirstToken(5);
        if (!modifiersDetailAST.branchContains(39) || !modifiersDetailAST.branchContains(64)) {
            return;
        }
        DetailAST nameDetailAST = detailAST.findFirstToken(58);
        String name = nameDetailAST.getText();
        if (name.equals("serialPersistentFields") || name.equals("serialVersionUID")) {
            return;
        }
        String regex = null;
        String typeName = this.getTypeName(detailAST, false);
        List<String> camelCaseTypeNames = this.getAttributeValues(_CAMEL_CASE_TYPE_NAMES_KEY);
        for (String camelCaseTypeName : camelCaseTypeNames) {
            if (!typeName.matches(camelCaseTypeName) && !this.isCollection(detailAST.findFirstToken(13))) continue;
            regex = _CAMEL_CASE_REGEX;
        }
        if (regex == null) {
            if (this._isImmutableFieldType(typeName)) {
                regex = _UPPER_CASE_REGEX;
            } else {
                regex = _CONSTANT_NAME_REGEX;
                typeName = null;
            }
        }
        String accessLevel = null;
        if (modifiersDetailAST.branchContains(61)) {
            accessLevel = "private";
            regex = StringUtil.replaceFirst(regex, '^', "^_");
        } else if (modifiersDetailAST.branchContains(63)) {
            accessLevel = "protected";
        } else if (modifiersDetailAST.branchContains(62)) {
            accessLevel = "public";
        } else {
            return;
        }
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(name);
        if (!matcher.find()) {
            if (typeName == null) {
                this.log(nameDetailAST, _MSG_INVALID_CONSTANT_NAME, new Object[]{accessLevel, name, regex});
            } else {
                this.log(nameDetailAST, _MSG_INVALID_CONSTANT_TYPE_NAME, new Object[]{accessLevel, name, typeName, regex});
            }
        }
    }

    private boolean _isImmutableFieldType(String typeName) {
        List<String> immutableFieldTypes = this.getAttributeValues(_IMMUTABLE_FIELD_TYPES_KEY);
        for (String immutableFieldType : immutableFieldTypes) {
            if (!typeName.equals(immutableFieldType) && !typeName.startsWith(immutableFieldType + "[]")) continue;
            return true;
        }
        return false;
    }
}

