/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.NaturalOrderStringComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.JSPSourceUtil;
import com.liferay.source.formatter.checks.util.JavaSourceUtil;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MethodCallsOrderCheck
extends BaseFileCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        return this._sortMethodCalls(fileName, content);
    }

    private String _getSortedCodeBlock(String codeBlock, String methodCall) {
        String previousParameters = null;
        String previousPutOrSetParameterName = null;
        PutOrSetParameterNameComparator putOrSetParameterNameComparator = new PutOrSetParameterNameComparator();
        int x = 0;
        String s;
        while ((s = StringUtil.trim(codeBlock.substring(x))).startsWith(methodCall)) {
            int compare;
            String parameters = null;
            int y = x = codeBlock.indexOf(40, x + 1);
            do {
                if ((y = codeBlock.indexOf(41, y + 1)) != -1) continue;
                return codeBlock;
            } while (ToolsUtil.getLevel(s = codeBlock.substring(x, y + 1), "(", ")") != 0 || ToolsUtil.getLevel(s, "{", "}") != 0);
            if (codeBlock.charAt(y + 1) != ';') {
                return codeBlock;
            }
            parameters = codeBlock.substring(x + 1, y);
            x = y + 2;
            List<String> parametersList = JavaSourceUtil.splitParameters(parameters);
            String putOrSetParameterName = parametersList.get(0);
            if (previousPutOrSetParameterName != null && (compare = putOrSetParameterNameComparator.compare(previousPutOrSetParameterName, putOrSetParameterName)) > 0) {
                String sortedCodeBlock = StringUtil.replaceFirst(codeBlock, previousParameters, parameters);
                return StringUtil.replaceLast(sortedCodeBlock, parameters, previousParameters);
            }
            previousParameters = parameters;
            previousPutOrSetParameterName = putOrSetParameterName;
        }
        return codeBlock;
    }

    private boolean _isAllowedVariableType(String content, String variableName, String[] variableTypeNames) {
        if (variableTypeNames.length == 0) {
            return true;
        }
        for (String variableTypeName : variableTypeNames) {
            if (variableName.matches(variableTypeName)) {
                return true;
            }
            StringBundler sb = new StringBundler(5);
            sb.append("\\W");
            sb.append(variableTypeName);
            sb.append("(<.*>|\\(\\))?\\s+");
            sb.append(variableName);
            sb.append("\\W");
            Pattern pattern = Pattern.compile(sb.toString());
            Matcher matcher = pattern.matcher(content);
            if (matcher.find()) {
                return true;
            }
            sb = new StringBundler(5);
            sb.append("\\W");
            sb.append(variableName);
            sb.append(" =\\s+new ");
            sb.append(variableTypeName);
            sb.append("(<.*>|\\(\\))");
            pattern = Pattern.compile(sb.toString());
            matcher = pattern.matcher(content);
            if (!matcher.find()) continue;
            return true;
        }
        return false;
    }

    private String _sortAnonymousClassMethodCalls(String content, String methodName, String ... variableTypeNames) {
        for (String variableTypeName : variableTypeNames) {
            Pattern pattern = Pattern.compile("\\Wnew " + variableTypeName + "[(<][^;]*?\\) \\{\n");
            Matcher matcher = pattern.matcher(content);
            while (matcher.find()) {
                String sortedCodeBlock;
                String codeBlock;
                int x;
                int y;
                int lineNumber = this.getLineNumber(content, matcher.end() - 1);
                if (!Objects.equals(StringUtil.trim(this.getLine(content, lineNumber + 1)), "{") || (y = content.indexOf("\t}\n", x = this.getLineStartPos(content, lineNumber + 2))) == -1) continue;
                int z = content.indexOf("\n\n", x);
                if (z != -1 && z < y) {
                    y = z;
                }
                if ((codeBlock = content.substring(x, y)).equals(sortedCodeBlock = this._getSortedCodeBlock(codeBlock, methodName + "("))) continue;
                return StringUtil.replaceFirst(content, codeBlock, sortedCodeBlock, matcher.start());
            }
        }
        return content;
    }

    private String _sortChainedMethodCalls(String content, String methodName, int expectedParameterCount, String ... variableTypeNames) {
        if (!content.contains("." + methodName + "(")) {
            return content;
        }
        Pattern pattern = Pattern.compile("\\W(\\w+)\\.(<[\\w\\[\\]\\?<>, ]*>)?" + methodName + "\\(");
        Matcher matcher = pattern.matcher(content);
        PutOrSetParameterNameComparator putOrSetParameterNameComparator = new PutOrSetParameterNameComparator();
        block0: while (matcher.find()) {
            if (!this._isAllowedVariableType(content, matcher.group(1), variableTypeNames)) continue;
            String previousParameters = null;
            String previousPutOrSetParameterName = null;
            int x = matcher.end() - 1;
            while (true) {
                int compare;
                String parameters = null;
                int y = x;
                do {
                    if ((y = content.indexOf(")", y + 1)) != -1) continue;
                    return content;
                } while (this.getLevel(content.substring(x, y + 1)) != 0);
                parameters = content.substring(x + 1, y);
                List<String> parametersList = JavaSourceUtil.splitParameters(parameters);
                if (parametersList.size() != expectedParameterCount) continue block0;
                String putOrSetParameterName = parametersList.get(0);
                if (previousPutOrSetParameterName != null && (compare = putOrSetParameterNameComparator.compare(previousPutOrSetParameterName, putOrSetParameterName)) > 0) {
                    String codeBlock = content.substring(matcher.start(), y + 1);
                    String newCodeBlock = StringUtil.replaceFirst(codeBlock, previousParameters, parameters);
                    newCodeBlock = StringUtil.replaceLast(newCodeBlock, parameters, previousParameters);
                    return StringUtil.replaceFirst(content, codeBlock, newCodeBlock, matcher.start());
                }
                String s = StringUtil.trim(content.substring(y + 1));
                if (!s.startsWith("." + methodName + "(")) continue block0;
                previousParameters = parameters;
                previousPutOrSetParameterName = putOrSetParameterName;
                x = content.indexOf("(", y + 1);
            }
        }
        return content;
    }

    private String _sortMethodCalls(String fileName, String content) {
        content = this._sortChainedMethodCalls(content, "put", 2, "ConcurrentHashMapBuilder", "HashMapBuilder", "JSONObject", "JSONUtil", "SoyContext", "TreeMapBuilder");
        content = this._sortMethodCalls(fileName, content, "add", "ConcurrentSkipListSet", "HashSet", "TreeSet");
        content = this._sortMethodCalls(fileName, content, "put", "ConcurrentHashMap", "HashMap", "JSONObject", "SortedMap", "TreeMap");
        content = this._sortMethodCalls(fileName, content, "setAttribute", new String[0]);
        return content;
    }

    private String _sortMethodCalls(String fileName, String content, String methodName, String ... variableTypeNames) {
        if (!(content = this._sortAnonymousClassMethodCalls(content, methodName, variableTypeNames)).contains("." + methodName + "(")) {
            return content;
        }
        Pattern pattern = Pattern.compile("[^;]\n\t+((\\w*)\\." + methodName + "\\()");
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            String sortedCodeBlock;
            String codeBlock;
            if (!this._isAllowedVariableType(content, matcher.group(2), variableTypeNames) || (fileName.endsWith(".jsp") || fileName.endsWith(".jspf")) && !JSPSourceUtil.isJavaSource(content, matcher.start())) continue;
            int x = content.indexOf("\n\n", matcher.end());
            if (x == -1) {
                x = content.length();
            }
            if ((codeBlock = content.substring(matcher.start() + 2, x)).equals(sortedCodeBlock = this._getSortedCodeBlock(codeBlock, matcher.group(1)))) continue;
            return StringUtil.replaceFirst(content, codeBlock, sortedCodeBlock, matcher.start());
        }
        return content;
    }

    private class PutOrSetParameterNameComparator
    extends NaturalOrderStringComparator {
        private final Pattern _multipleLineConstantPattern = Pattern.compile("\\.\n\t+");
        private final Pattern _multipleLineParameterNamePattern = Pattern.compile("\" \\+\n\t+\"");

        private PutOrSetParameterNameComparator() {
        }

        @Override
        public int compare(String putOrSetParameterName1, String putOrSetParameterName2) {
            Matcher matcher = this._multipleLineConstantPattern.matcher(putOrSetParameterName1);
            putOrSetParameterName1 = matcher.replaceAll(".");
            matcher = this._multipleLineConstantPattern.matcher(putOrSetParameterName2);
            putOrSetParameterName2 = matcher.replaceAll(".");
            String strippedParameterName1 = MethodCallsOrderCheck.this.stripQuotes(putOrSetParameterName1);
            String strippedParameterName2 = MethodCallsOrderCheck.this.stripQuotes(putOrSetParameterName2);
            if (strippedParameterName1.contains("(") || strippedParameterName2.contains("(")) {
                return 0;
            }
            matcher = this._multipleLineParameterNamePattern.matcher(putOrSetParameterName1);
            if (matcher.find()) {
                putOrSetParameterName1 = matcher.replaceAll("");
            }
            if ((matcher = this._multipleLineParameterNamePattern.matcher(putOrSetParameterName2)).find()) {
                putOrSetParameterName2 = matcher.replaceAll("");
            }
            if (putOrSetParameterName1.matches("\".*\"") && putOrSetParameterName2.matches("\".*\"")) {
                String strippedQuotes1 = putOrSetParameterName1.substring(1, putOrSetParameterName1.length() - 1);
                String strippedQuotes2 = putOrSetParameterName2.substring(1, putOrSetParameterName2.length() - 1);
                return super.compare(strippedQuotes1, strippedQuotes2);
            }
            int value = super.compare(putOrSetParameterName1, putOrSetParameterName2);
            if (putOrSetParameterName1.startsWith("\"") ^ putOrSetParameterName2.startsWith("\"")) {
                return -value;
            }
            return value;
        }
    }
}

