/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.java.parser;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.tools.java.parser.BaseJavaExpression;
import com.liferay.portal.tools.java.parser.JavaExpression;
import com.liferay.portal.tools.java.parser.JavaSimpleValue;
import com.liferay.portal.tools.java.parser.JavaType;
import java.util.List;

public class JavaMethodCall
extends BaseJavaExpression {
    private List<JavaType> _genericJavaTypes;
    private boolean _insideConstructorCall;
    private boolean _methodCallWithinClass;
    private final JavaSimpleValue _methodName;
    private List<JavaExpression> _parameterValueJavaExpressions;
    private boolean _statementCondition;
    private boolean _useChainStyle;

    public JavaMethodCall(String methodName) {
        this._methodName = new JavaSimpleValue(methodName);
    }

    public int getChainSize() {
        JavaExpression chainedJavaExpression = this.getChainedJavaExpression();
        if (!(chainedJavaExpression instanceof JavaMethodCall)) {
            return 0;
        }
        JavaMethodCall javaMethodCall = (JavaMethodCall)chainedJavaExpression;
        return javaMethodCall.getChainSize() + 1;
    }

    public List<JavaExpression> getParameterValueJavaExpressions() {
        return this._parameterValueJavaExpressions;
    }

    public void setGenericJavaTypes(List<JavaType> genericJavaTypes) {
        this._genericJavaTypes = genericJavaTypes;
    }

    public void setInsideConstructorCall(boolean insideConstructorCall) {
        this._insideConstructorCall = insideConstructorCall;
    }

    public void setMethodCallWithinClass(boolean methodCallWithinClass) {
        this._methodCallWithinClass = methodCallWithinClass;
    }

    public void setParameterValueJavaExpressions(List<JavaExpression> parameterValueJavaExpressions) {
        this._parameterValueJavaExpressions = parameterValueJavaExpressions;
    }

    public void setStatementCondition(boolean statementCondition) {
        this._statementCondition = statementCondition;
    }

    public void setUseChainStyle(boolean useChainStyle) {
        this._useChainStyle = useChainStyle;
        JavaExpression chainedJavaExpression = this.getChainedJavaExpression();
        if (chainedJavaExpression instanceof JavaMethodCall) {
            JavaMethodCall javaMethodCall = (JavaMethodCall)chainedJavaExpression;
            javaMethodCall.setUseChainStyle(useChainStyle);
        }
    }

    @Override
    protected String getString(String indent, String prefix, String suffix, int maxLineLength, boolean forceLineBreak) {
        String originalIndent = indent;
        StringBundler sb = new StringBundler();
        sb.append(indent);
        indent = "\t" + indent;
        if (this._genericJavaTypes != null) {
            this.append(sb, this._genericJavaTypes, indent, prefix + "<", ">", maxLineLength);
            prefix = "";
        }
        if (this._parameterValueJavaExpressions.isEmpty()) {
            if (this._isUseChainStyle() && this.getChainedJavaExpression() != null) {
                this.append(sb, this._methodName, indent, prefix, "(", maxLineLength, false);
                sb.append("\n");
                sb.append(originalIndent);
                sb.append(")");
                sb.append(suffix);
            } else {
                this.append(sb, this._methodName, indent, prefix, "()" + suffix, maxLineLength, false);
            }
        } else {
            indent = this.append(sb, this._methodName, indent, prefix, "(", maxLineLength, false);
            if (this._isUseChainStyle()) {
                this.appendNewLine(sb, this._parameterValueJavaExpressions, indent, maxLineLength);
                sb.append("\n");
                sb.append(originalIndent);
                sb.append(")");
                sb.append(suffix);
            } else if (forceLineBreak) {
                this.appendNewLine(sb, this._parameterValueJavaExpressions, indent, "", ")" + suffix, maxLineLength);
            } else {
                this.append(sb, this._parameterValueJavaExpressions, indent, "", ")" + suffix, maxLineLength);
            }
        }
        return sb.toString();
    }

    private boolean _isUseChainStyle() {
        if (this._statementCondition) {
            return false;
        }
        if (this._useChainStyle) {
            return this._useChainStyle;
        }
        int chainSize = this.getChainSize();
        if (chainSize == 0) {
            return false;
        }
        if (chainSize == 1 && (this._insideConstructorCall || this._parameterValueJavaExpressions.isEmpty() && this._methodCallWithinClass)) {
            return false;
        }
        this.setUseChainStyle(true);
        return true;
    }
}

