/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.SourceUtil;
import com.liferay.source.formatter.util.SourceFormatterUtil;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.Element;

public class XMLLog4jLoggersCheck
extends BaseFileCheck {
    private Set<String> _classNames;

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        if (this.isPortalSource() && (fileName.endsWith("-log4j-ext.xml") || fileName.endsWith("-log4j.xml"))) {
            this._checkLoggers(fileName, content);
        }
        return content;
    }

    private void _checkLoggers(String fileName, String content) throws Exception {
        Set<String> classNames = this._getClassNames();
        if (classNames.isEmpty()) {
            return;
        }
        Document document = SourceUtil.readXML(content);
        if (document == null) {
            return;
        }
        Element rootElement = document.getRootElement();
        for (Element loggersElement : rootElement.elements("Loggers")) {
            for (Element loggerElement : loggersElement.elements("Logger")) {
                String name = loggerElement.attributeValue("name");
                if (!name.startsWith("com.liferay") || classNames.contains(name)) continue;
                boolean exists = false;
                for (String className : classNames) {
                    if (!className.startsWith(name)) continue;
                    exists = true;
                    break;
                }
                if (exists) continue;
                this.addMessage(fileName, "Class/package does not exist: " + name);
            }
        }
    }

    private synchronized Set<String> _getClassNames() throws Exception {
        if (this._classNames != null) {
            return this._classNames;
        }
        this._classNames = new HashSet<String>();
        File file = this.getPortalDir();
        List<String> fileNames = SourceFormatterUtil.scanForFileNames(file.getCanonicalPath(), new String[]{"**/com/liferay/**/*.java"});
        for (String fileName : fileNames) {
            fileName = fileName.substring(0, fileName.lastIndexOf(46));
            fileName = StringUtil.replace(fileName, '/', '.');
            this._classNames.add(fileName.substring(fileName.indexOf("com.liferay")));
        }
        return this._classNames;
    }
}

