/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UpgradeJavaPortletSharedSearchSettingsCheck
extends BaseFileCheck {
    private static final Pattern _getParameterValuesOrGetPortletPreferencesPattern = Pattern.compile("Optional\\s*<(?:String\\[\\]|PortletPreferences)>\\s*\\w+\\s*=\\s*(\\w+)\\.(?:getParameterValues|getPortletPreferences)\\(");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        if (!fileName.endsWith(".java")) {
            return content;
        }
        String newContent = content;
        Matcher matcher = _getParameterValuesOrGetPortletPreferencesPattern.matcher(content);
        while (matcher.find()) {
            String variableTypeName = this.getVariableTypeName(newContent, null, newContent, fileName, matcher.group(1));
            if (variableTypeName == null || !variableTypeName.equals("PortletSharedSearchSettings")) continue;
            String methodStart = matcher.group();
            String newMethodStart = StringUtil.removeSubstring(methodStart, "Optional");
            newMethodStart = StringUtil.removeFirst(newMethodStart, "<");
            newMethodStart = StringUtil.removeFirst(newMethodStart, ">");
            newContent = StringUtil.replaceFirst(newContent, methodStart, newMethodStart);
        }
        return newContent;
    }
}

