/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.source.formatter.check.BaseFileCheck;
import java.io.IOException;

public class PropertiesLanguageContractionsCheck
extends BaseFileCheck {
    private static final String[] _CONTRACTIONS = new String[]{"aren't", "can't", "could've", "couldn't", "didn't", "doesn't", "don't", "hadn't", "hasn't", "haven't", "how's", "I'd", "I'll", "I've", "isn't", "it's", "let's", "shouldn't", "that's", "there's", "wasn't", "we'd", "we'll", "we're", "we've", "weren't", "what's", "where's", "won't", "would've", "wouldn't", "you'd", "you'll", "you're", "you've"};

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        if (!fileName.endsWith("/content/Language.properties")) {
            return content;
        }
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            String line = null;
            int lineNumber = 0;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                String[] array;
                ++lineNumber;
                int x = line.indexOf("'");
                if (x == -1 || (array = line.split("=", 2)).length != 2) continue;
                String lowerCaseDescription = array[1].toLowerCase();
                for (String contraction : _CONTRACTIONS) {
                    int i = lowerCaseDescription.indexOf(contraction);
                    if (i == -1 || Character.isLetterOrDigit(lowerCaseDescription.charAt(i - 1)) || Character.isLetterOrDigit(lowerCaseDescription.charAt(i + contraction.length()))) continue;
                    this.addMessage(fileName, StringBundler.concat("Do not use contraction \"", contraction, "\" in the description of key \"", array[0], "\""), lineNumber);
                }
            }
        }
        return content;
    }
}

