/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.SourceUtil;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PoshiStylingCheck
extends BaseFileCheck {
    private static final Pattern _singleLineCommentPattern = Pattern.compile("^([ \t]*)// *(\t*.*)");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        if (fileName.endsWith(".path")) {
            return content;
        }
        if (SourceUtil.isXML(content)) {
            this.addMessage(fileName, "Use Poshi Script instead of Poshi XML");
            return content;
        }
        content = content.replaceAll("(?<!!)\\(contains\\(\"\\$\\{(.+?)\\}\", \"\\{\\1\\}\"\\)\\)", "(!(isSet($1)))");
        content = content.replaceAll("\\!\\(contains\\(\"\\$\\{(.+?)\\}\", \"\\{\\1\\}\"\\)\\)", "isSet($1)");
        return this._formatComments(content);
    }

    private String _formatComments(String content) throws IOException {
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            String line = null;
            String newComment = "";
            String previousComment = "";
            while ((line = unsyncBufferedReader.readLine()) != null) {
                Matcher matcher = _singleLineCommentPattern.matcher(line);
                if (!matcher.find()) {
                    previousComment = "";
                    sb.append(line);
                    sb.append("\n");
                    continue;
                }
                String comment = matcher.group(2);
                if (Validator.isNull(comment)) {
                    previousComment = "";
                    continue;
                }
                String indent = matcher.group(1);
                if (comment.startsWith("Ignore") || comment.startsWith("Ignoring") || comment.startsWith("Quarantine") || comment.startsWith("TODO") || comment.startsWith("Workaround") || !comment.endsWith(",") && !comment.endsWith("{") && !comment.endsWith("(") && !comment.endsWith(";") && !comment.equals("}") || comment.endsWith(",") && !comment.contains(" = ")) {
                    String trimmedComment = comment.trim();
                    if (!previousComment.startsWith("// ")) {
                        String upperCaseFirstChar = StringUtil.toUpperCase(trimmedComment.substring(0, 1));
                        trimmedComment = upperCaseFirstChar + trimmedComment.substring(1);
                    }
                    if (previousComment.matches("//[^ ].+")) {
                        sb.append("\n");
                    }
                    newComment = "// " + trimmedComment;
                } else {
                    if (previousComment.startsWith("// ")) {
                        sb.append("\n");
                    }
                    newComment = "//" + comment;
                }
                sb.append(indent);
                sb.append(newComment);
                sb.append("\n");
                previousComment = newComment;
            }
        }
        if (sb.length() > 0) {
            sb.setIndex(sb.index() - 1);
        }
        return sb.toString();
    }
}

