/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.check.BaseJavaTermCheck;
import com.liferay.source.formatter.parser.JavaParameter;
import com.liferay.source.formatter.parser.JavaSignature;
import com.liferay.source.formatter.parser.JavaTerm;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaFinalVariableCheck
extends BaseJavaTermCheck {
    private static final Pattern _anonymouseClassPattern = Pattern.compile("\\Wnew\\s[\\w\\s\\.<>,\\?]+\\(");
    private static final Pattern _finalVariablePattern = Pattern.compile("[\t,]final [\\w\\s<>,]+?([\\w]+)\\s*[;=]");

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) {
        String content = javaTerm.getContent();
        Matcher matcher = _finalVariablePattern.matcher(content);
        while (matcher.find()) {
            if (this._requiresFinal(content, matcher.group(1))) continue;
            return StringUtil.replaceFirst(content, "final ", "", matcher.start());
        }
        int x = content.indexOf("{\n");
        if (x == -1) {
            x = content.length() - 1;
        }
        JavaSignature javaSignature = javaTerm.getSignature();
        for (JavaParameter javaParameter : javaSignature.getParameters()) {
            String name;
            if (!javaParameter.isFinal() || this._requiresFinal(content, name = javaParameter.getParameterName())) continue;
            String type = javaParameter.getParameterType();
            int y = content.lastIndexOf(StringBundler.concat("final ", type, " ", name), x);
            if (y != -1) {
                return StringUtil.replaceFirst(content, "final ", "", y - 1);
            }
            this.addMessage(fileName, StringBundler.concat("Keyword \"final\" not required for parameter \"", name, "\""), javaTerm.getLineNumber());
        }
        return content;
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_CONSTRUCTOR, JAVA_METHOD};
    }

    private int _getMatchingCloseCharPos(String content, String openChar, String closeChar, int startPos) {
        String s;
        int level;
        int endPos = startPos;
        do {
            if ((endPos = content.indexOf(closeChar, endPos + 1)) != -1) continue;
            return -1;
        } while ((level = ToolsUtil.getLevel(s = content.substring(startPos, endPos + 1), openChar, closeChar)) != 0);
        return endPos;
    }

    private boolean _requiresFinal(String content, String variableName) {
        Matcher matcher = _anonymouseClassPattern.matcher(content);
        while (matcher.find()) {
            int y;
            String body;
            int x = this._getMatchingCloseCharPos(content, "(", ")", matcher.start());
            String followingCode = content.substring(x);
            if (!followingCode.startsWith(") {") || !(body = content.substring(x + 3, y = this._getMatchingCloseCharPos(content, "{", "}", x))).matches("(?s).*\\W" + variableName + "\\W.*")) continue;
            return true;
        }
        return false;
    }
}

