/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GradleTestUtilDeployDirCheck
extends BaseFileCheck {
    private static final Pattern _liferayPattern = Pattern.compile("(\n|\\A)(\t*)liferay \\{\n");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (!absolutePath.endsWith("-test-util/build.gradle")) {
            return content;
        }
        int pos = absolutePath.lastIndexOf(47);
        File lfrBuildPortalFile = new File(absolutePath.substring(0, pos + 1) + ".lfrbuild-portal");
        if (!this._isDeployedToOSGiTestDir(content)) {
            if (lfrBuildPortalFile.exists()) {
                this.addMessage(fileName, "Missing deploy to \"osgi/test\" when \".lfrbuild-portal\" exists");
            }
        } else if (!lfrBuildPortalFile.exists()) {
            this.addMessage(fileName, "Do not deploy to \"osgi/test\" when \".lfrbuild-portal\" does not exist");
        }
        return content;
    }

    private boolean _isDeployedToOSGiTestDir(String content) {
        String match;
        Matcher matcher = _liferayPattern.matcher(content);
        if (!matcher.find()) {
            return false;
        }
        int x = matcher.start();
        do {
            if ((x = content.indexOf("}", x + 1)) != -1) continue;
            return false;
        } while (ToolsUtil.getLevel(match = content.substring(matcher.end(2), x + 1), "{", "}") != 0 || !match.contains("deployDir = file(\"${liferayHome}/osgi/test\")"));
        return true;
    }
}

