/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.check.BaseGradleFileCheck;
import com.liferay.source.formatter.parser.GradleFile;
import java.util.Collection;
import java.util.Set;

public class GradleBlockOrderCheck
extends BaseGradleFileCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, GradleFile gradleFile, String content) {
        Set<String> properties;
        Set<String> tasks;
        String initializeBlock;
        String extScriptBlock;
        Set<String> applyPlugins;
        String pluginsScriptBlock;
        if (absolutePath.contains("/project-templates-")) {
            return content;
        }
        StringBundler sb = new StringBundler(16);
        sb.append(gradleFile.getImportsBlock());
        String buildScriptBlock = gradleFile.getBuildScriptBlock();
        if (Validator.isNotNull(buildScriptBlock)) {
            sb.append(buildScriptBlock);
            sb.append("\n\n");
        }
        if (Validator.isNotNull(pluginsScriptBlock = gradleFile.getPluginsScriptBlock())) {
            sb.append(pluginsScriptBlock);
            sb.append("\n\n");
        }
        if (!(applyPlugins = gradleFile.getApplyPlugins()).isEmpty()) {
            sb.append(this._merge(applyPlugins, "\n"));
            sb.append("\n\n");
        }
        if (Validator.isNotNull(extScriptBlock = gradleFile.getExtScriptBlock())) {
            sb.append(extScriptBlock);
            sb.append("\n\n");
        }
        if (Validator.isNotNull(initializeBlock = gradleFile.getInitializeBlock())) {
            sb.append(initializeBlock);
            sb.append("\n\n");
        }
        if (!(tasks = gradleFile.getTasks()).isEmpty()) {
            sb.append(this._merge(tasks, "\n"));
            sb.append("\n\n");
        }
        if (!(properties = gradleFile.getProperties()).isEmpty()) {
            sb.append(this._merge(properties, "\n"));
            sb.append("\n\n");
        }
        sb.append(gradleFile.getBodyBlock());
        return StringUtil.trim(sb.toString());
    }

    private String _merge(Collection<String> lines, String delimiter) {
        if (lines == null) {
            return null;
        }
        if (lines.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(2 * lines.size());
        for (String line : lines) {
            sb.append(line);
            sb.append(delimiter);
        }
        sb.setIndex(sb.index() - 1);
        return sb.toString();
    }
}

