/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.check.BaseTagAttributesCheck;
import com.liferay.source.formatter.check.util.SourceUtil;

public class FTLTagAttributesCheck
extends BaseTagAttributesCheck {
    @Override
    protected BaseTagAttributesCheck.Tag doFormatLineBreaks(BaseTagAttributesCheck.Tag tag, String absolutePath) {
        return tag;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        content = this.formatIncorrectLineBreak(fileName, content);
        content = this._formatMacroTagAttributes(content);
        return content;
    }

    private String _formatMacroTagAttributes(String content) throws Exception {
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            String line = null;
            int lineNumber = 0;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                String newTagString;
                int startPos;
                String tagString;
                String tagLine;
                int tagNameEndIndex;
                String trimmedLine = StringUtil.trimLeading(line);
                if (!trimmedLine.startsWith("<#macro") || (tagNameEndIndex = (tagLine = (tagString = this.getTag(content, startPos = this.getLineStartPos(content, ++lineNumber))).replaceAll("\n\t*", " ")).indexOf(" ", 8)) == -1) continue;
                String tagName = tagLine.substring(0, tagNameEndIndex);
                String tagAttributes = StringUtil.trim(tagLine.substring(tagNameEndIndex, tagLine.length() - 1));
                if (Validator.isNull(tagAttributes)) continue;
                String indent = SourceUtil.getIndent(line) + "\t";
                String newTagAttributes = "";
                int x = -1;
                while ((x = tagAttributes.indexOf(" ", x + 1)) != -1) {
                    char nextChar;
                    char previousChar;
                    if (ToolsUtil.isInsideQuotes(tagAttributes, x) || x > 0 && (previousChar = tagAttributes.charAt(x - 1)) == '=' || x < tagAttributes.length() - 1 && (nextChar = tagAttributes.charAt(x + 1)) == '=') continue;
                    newTagAttributes = newTagAttributes + "\n" + indent + tagAttributes.substring(0, x);
                    tagAttributes = tagAttributes.substring(x + 1);
                    x = -1;
                }
                if (Validator.isNotNull(tagAttributes)) {
                    newTagAttributes = newTagAttributes + "\n" + indent + tagAttributes;
                }
                if (tagString.equals(newTagString = StringBundler.concat(tagName, newTagAttributes, "\n", ">"))) continue;
                String string = StringUtil.replaceFirst(content, tagString, newTagString, startPos);
                return string;
            }
        }
        return content;
    }
}

