/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.check.BaseTagAttributesCheck;
import java.util.ArrayList;
import java.util.List;

public class CSPTagIllegalAttributesCheck
extends BaseTagAttributesCheck {
    private static final String _IGNORED_FTL_TAG_PREFIXES_KEY = "ignoredFTLTagPrefixes";
    private static final String _IGNORED_JSP_TAG_PREFIXES_KEY = "ignoredJSPTagPrefixes";
    private static final String _ILLEGAL_ATTRIBUTE_NAMES_KEY = "illegalAttributeNames";

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        List<Object> ignoredTagPrefixes = new ArrayList();
        String liferayUiCSPTagClose = "";
        String liferayUiCSPTagOpen = "";
        if (fileName.endsWith(".ftl")) {
            ignoredTagPrefixes = this.getAttributeValues(_IGNORED_FTL_TAG_PREFIXES_KEY, absolutePath);
            liferayUiCSPTagClose = "</@liferay_ui.csp>";
            liferayUiCSPTagOpen = "<@liferay_ui.csp>";
        } else if (fileName.endsWith(".jsp") || fileName.endsWith(".jspf") || fileName.endsWith(".jspx")) {
            ignoredTagPrefixes = this.getAttributeValues(_IGNORED_JSP_TAG_PREFIXES_KEY, absolutePath);
            liferayUiCSPTagClose = "</liferay-ui:csp>";
            liferayUiCSPTagOpen = "<liferay-ui:csp>";
        }
        String lowerCaseContent = StringUtil.toLowerCase(content);
        List<String> illegalAttributeNames = this.getAttributeValues(_ILLEGAL_ATTRIBUTE_NAMES_KEY, absolutePath);
        for (String illegalAttributeName : illegalAttributeNames) {
            int x = -1;
            block1: while ((x = lowerCaseContent.indexOf(illegalAttributeName + "=", x + 1)) != -1) {
                String tagName;
                Object tag;
                String tagString;
                int tagStartPosition;
                if (x == 0 || !Character.isWhitespace(content.charAt(x - 1)) || this.isJavaSource(content, x) || (tagStartPosition = this._getTagStartPosition(content, x)) == -1 || Validator.isNull(tagString = this.getTag(content, tagStartPosition)) || illegalAttributeName.equals("style") && ((tag = this.parseTag(tagString, false)) == null || !(tagName = ((BaseTagAttributesCheck.Tag)tag).getName()).matches("\\w+"))) continue;
                tag = ignoredTagPrefixes.iterator();
                while (tag.hasNext()) {
                    String ignoredTagPrefix = (String)tag.next();
                    if (!tagString.startsWith(ignoredTagPrefix)) continue;
                    continue block1;
                }
                String previousPart = content.substring(0, tagStartPosition);
                int y = previousPart.lastIndexOf(liferayUiCSPTagClose);
                int z = previousPart.lastIndexOf(liferayUiCSPTagOpen);
                if (z > y) continue;
                this.addMessage(fileName, "Tag attribute \"" + illegalAttributeName + "\" is not allowed, see LPD-18227", this.getLineNumber(content, x));
            }
        }
        return content;
    }

    private int _getTagStartPosition(String content, int x) {
        while (x >= 0) {
            char c = content.charAt(x);
            if (c == '<' && content.charAt(x + 1) != '=' && content.charAt(x + 1) != '%' && !this.isJavaSource(content, x, true)) {
                return x;
            }
            --x;
        }
        return -1;
    }
}

