/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.BaseImportsFormatter;
import com.liferay.portal.tools.ImportPackage;
import com.liferay.source.formatter.BNDImportPackage;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BNDImportsFormatter
extends BaseImportsFormatter {
    public static String getImports(String content, Pattern pattern) {
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            return matcher.group(3);
        }
        return null;
    }

    @Override
    protected ImportPackage createImportPackage(String line) {
        String importString;
        if (line.endsWith("\\")) {
            line = line.substring(0, line.length() - 1);
        }
        if (line.endsWith(",")) {
            line = line.substring(0, line.length() - 1);
        }
        if (Validator.isNull(importString = StringUtil.trim(line))) {
            return null;
        }
        int pos = importString.indexOf(";");
        if (pos != -1) {
            importString = importString.substring(0, pos);
            pos = line.indexOf(";");
            line = line.substring(0, pos + 1) + this._sortAttributes(line.substring(pos + 1));
        }
        return new BNDImportPackage(importString, line);
    }

    @Override
    protected String doFormat(String content, Pattern importPattern, String packageDir, String className) throws IOException {
        String imports = BNDImportsFormatter.getImports(content, importPattern);
        if (Validator.isNull(imports)) {
            return content;
        }
        String newImports = this.sortAndGroupImports(imports);
        newImports = newImports.substring(0, newImports.length() - 1);
        if ((newImports = StringUtil.replace(newImports, new String[]{"\n", "\n,\\"}, new String[]{",\\\n", "\n\t\\"})).contains(",\\\n")) {
            newImports = newImports.replaceAll("(?m)^\t*", "\t");
        }
        if (!imports.equals(newImports)) {
            content = StringUtil.replaceFirst(content, imports, newImports);
        }
        return content;
    }

    private String _sortAttributes(String attributes) {
        List<String> attributeList = ListUtil.fromString(attributes, ";");
        Collections.sort(attributeList, new Comparator<String>(){

            @Override
            public int compare(String attribute1, String attribute2) {
                if (attribute1.startsWith("-") && !attribute2.startsWith("-")) {
                    return 1;
                }
                if (!attribute1.startsWith("-") && attribute2.startsWith("-")) {
                    return -1;
                }
                String attributeName1 = attribute1.replaceFirst("(.+?):?=.+", "$1");
                String attributeName2 = attribute2.replaceFirst("(.+?):?=.+", "$1");
                return attributeName1.compareTo(attributeName2);
            }
        });
        return ListUtil.toString(attributeList, "", ";");
    }
}

