/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.core.elements;

import com.liferay.poshi.core.elements.PoshiComment;
import com.liferay.poshi.core.script.PoshiScriptParserException;
import org.dom4j.Comment;

public class MultilinePoshiComment
extends PoshiComment {
    @Override
    public PoshiComment clone(Comment comment) {
        String commentText = comment.getText();
        if (commentText.contains("\n")) {
            return new MultilinePoshiComment(comment);
        }
        return null;
    }

    @Override
    public PoshiComment clone(String poshiScript) throws PoshiScriptParserException {
        if (this.isPoshiScriptComment(poshiScript)) {
            return new MultilinePoshiComment(poshiScript);
        }
        return null;
    }

    @Override
    public boolean isPoshiScriptComment(String poshiScript) {
        return (poshiScript = poshiScript.trim()).endsWith("*/") && poshiScript.startsWith("/*");
    }

    @Override
    public void parsePoshiScript(String poshiScript) throws PoshiScriptParserException {
        this.setText(poshiScript.substring(2, poshiScript.length() - 2));
    }

    @Override
    public String toPoshiScript() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n\t/*");
        sb.append(this.getText());
        sb.append("*/");
        return sb.toString();
    }

    protected MultilinePoshiComment() {
    }

    protected MultilinePoshiComment(Comment comment) {
        super(comment);
    }

    protected MultilinePoshiComment(String poshiScript) throws PoshiScriptParserException {
        super(poshiScript);
    }
}

