/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@StatelessCheck
public class VariableDeclarationUsageDistanceCheck
extends AbstractCheck {
    public static final String MSG_KEY = "variable.declaration.usage.distance";
    public static final String MSG_KEY_EXT = "variable.declaration.usage.distance.extend";
    private static final int DEFAULT_DISTANCE = 3;
    private int allowedDistance = 3;
    private Pattern ignoreVariablePattern = Pattern.compile("");
    private boolean validateBetweenScopes;
    private boolean ignoreFinal = true;

    public void setAllowedDistance(int allowedDistance) {
        this.allowedDistance = allowedDistance;
    }

    public void setIgnoreVariablePattern(Pattern pattern) {
        this.ignoreVariablePattern = pattern;
    }

    public void setValidateBetweenScopes(boolean validateBetweenScopes) {
        this.validateBetweenScopes = validateBetweenScopes;
    }

    public void setIgnoreFinal(boolean ignoreFinal) {
        this.ignoreFinal = ignoreFinal;
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{10};
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST variable;
        int parentType = ast.getParent().getType();
        DetailAST modifiers = ast.getFirstChild();
        if (!(parentType == 6 || this.ignoreFinal && modifiers.findFirstToken(39) != null || this.isVariableMatchesIgnorePattern((variable = ast.findFirstToken(58)).getText()))) {
            DetailAST semicolonAst = ast.getNextSibling();
            Map.Entry<DetailAST, Integer> entry = this.validateBetweenScopes ? VariableDeclarationUsageDistanceCheck.calculateDistanceBetweenScopes(semicolonAst, variable) : VariableDeclarationUsageDistanceCheck.calculateDistanceInSingleScope(semicolonAst, variable);
            DetailAST variableUsageAst = entry.getKey();
            int dist = entry.getValue();
            if (dist > this.allowedDistance && !VariableDeclarationUsageDistanceCheck.isInitializationSequence(variableUsageAst, variable.getText())) {
                if (this.ignoreFinal) {
                    this.log(ast, MSG_KEY_EXT, variable.getText(), dist, this.allowedDistance);
                } else {
                    this.log(ast, MSG_KEY, variable.getText(), dist, this.allowedDistance);
                }
            }
        }
    }

    private static String getInstanceName(DetailAST methodCallAst) {
        String methodCallName = FullIdent.createFullIdentBelow(methodCallAst).getText();
        int lastDotIndex = methodCallName.lastIndexOf(46);
        String instanceName = "";
        if (lastDotIndex != -1) {
            instanceName = methodCallName.substring(0, lastDotIndex);
        }
        return instanceName;
    }

    private static boolean isInitializationSequence(DetailAST variableUsageAst, String variableName) {
        boolean result = true;
        boolean isUsedVariableDeclarationFound = false;
        String initInstanceName = "";
        block5: for (DetailAST currentSiblingAst = variableUsageAst; result && !isUsedVariableDeclarationFound && currentSiblingAst != null; currentSiblingAst = currentSiblingAst.getPreviousSibling()) {
            switch (currentSiblingAst.getType()) {
                case 28: {
                    DetailAST methodCallAst = currentSiblingAst.getFirstChild();
                    if (methodCallAst.getType() == 27) {
                        String instanceName = VariableDeclarationUsageDistanceCheck.getInstanceName(methodCallAst);
                        if (instanceName.isEmpty()) {
                            result = false;
                            continue block5;
                        }
                        if (instanceName.equals(initInstanceName)) continue block5;
                        if (initInstanceName.isEmpty()) {
                            initInstanceName = instanceName;
                            continue block5;
                        }
                        result = false;
                        continue block5;
                    }
                    result = false;
                    continue block5;
                }
                case 10: {
                    String currentVariableName = currentSiblingAst.findFirstToken(58).getText();
                    isUsedVariableDeclarationFound = variableName.equals(currentVariableName);
                    continue block5;
                }
                case 45: {
                    continue block5;
                }
                default: {
                    result = false;
                }
            }
        }
        return result;
    }

    private static Map.Entry<DetailAST, Integer> calculateDistanceInSingleScope(DetailAST semicolonAst, DetailAST variableIdentAst) {
        int dist = 0;
        boolean firstUsageFound = false;
        DetailAST variableUsageAst = null;
        for (DetailAST currentAst = semicolonAst; !firstUsageFound && currentAst != null && currentAst.getType() != 73; currentAst = currentAst.getNextSibling()) {
            if (currentAst.getFirstChild() == null) continue;
            if (VariableDeclarationUsageDistanceCheck.isChild(currentAst, variableIdentAst)) {
                dist = VariableDeclarationUsageDistanceCheck.getDistToVariableUsageInChildNode(currentAst, variableIdentAst, dist);
                variableUsageAst = currentAst;
                firstUsageFound = true;
                continue;
            }
            if (currentAst.getType() == 10) continue;
            ++dist;
        }
        if (!firstUsageFound) {
            dist = 0;
        }
        return new AbstractMap.SimpleEntry<Object, Integer>(variableUsageAst, dist);
    }

    private static int getDistToVariableUsageInChildNode(DetailAST childNode, DetailAST varIdent, int currentDistToVarUsage) {
        DetailAST examineNode = childNode;
        if (examineNode.getType() == 22) {
            examineNode = examineNode.getFirstChild().getNextSibling();
        }
        int resultDist = currentDistToVarUsage;
        switch (examineNode.getType()) {
            case 10: {
                ++resultDist;
                break;
            }
            case 7: {
                resultDist = 0;
                break;
            }
            case 83: 
            case 84: 
            case 85: 
            case 89: 
            case 91: {
                if (VariableDeclarationUsageDistanceCheck.isVariableInOperatorExpr(examineNode, varIdent)) {
                    ++resultDist;
                    break;
                }
                resultDist = 0;
                break;
            }
            default: {
                if (examineNode.findFirstToken(7) == null) {
                    ++resultDist;
                    break;
                }
                resultDist = 0;
            }
        }
        return resultDist;
    }

    private static Map.Entry<DetailAST, Integer> calculateDistanceBetweenScopes(DetailAST ast, DetailAST variable) {
        int dist = 0;
        DetailAST currentScopeAst = ast;
        DetailAST variableUsageAst = null;
        while (currentScopeAst != null) {
            Map.Entry<List<DetailAST>, Integer> searchResult = VariableDeclarationUsageDistanceCheck.searchVariableUsageExpressions(variable, currentScopeAst);
            currentScopeAst = null;
            List<DetailAST> variableUsageExpressions = searchResult.getKey();
            dist += searchResult.getValue().intValue();
            if (variableUsageExpressions.size() == 1) {
                DetailAST blockWithVariableUsage = variableUsageExpressions.get(0);
                DetailAST exprWithVariableUsage = null;
                switch (blockWithVariableUsage.getType()) {
                    case 10: 
                    case 28: {
                        ++dist;
                        break;
                    }
                    case 84: 
                    case 85: 
                    case 91: {
                        exprWithVariableUsage = VariableDeclarationUsageDistanceCheck.getFirstNodeInsideForWhileDoWhileBlocks(blockWithVariableUsage, variable);
                        break;
                    }
                    case 83: {
                        exprWithVariableUsage = VariableDeclarationUsageDistanceCheck.getFirstNodeInsideIfBlock(blockWithVariableUsage, variable);
                        break;
                    }
                    case 89: {
                        exprWithVariableUsage = VariableDeclarationUsageDistanceCheck.getFirstNodeInsideSwitchBlock(blockWithVariableUsage, variable);
                        break;
                    }
                    case 95: {
                        exprWithVariableUsage = VariableDeclarationUsageDistanceCheck.getFirstNodeInsideTryCatchFinallyBlocks(blockWithVariableUsage, variable);
                        break;
                    }
                    default: {
                        exprWithVariableUsage = blockWithVariableUsage.getFirstChild();
                    }
                }
                currentScopeAst = exprWithVariableUsage;
                if (exprWithVariableUsage == null) {
                    variableUsageAst = blockWithVariableUsage;
                    continue;
                }
                variableUsageAst = exprWithVariableUsage;
                continue;
            }
            if (variableUsageExpressions.isEmpty()) {
                variableUsageAst = null;
                continue;
            }
            ++dist;
            variableUsageAst = variableUsageExpressions.get(0);
        }
        return new AbstractMap.SimpleEntry<Object, Integer>(variableUsageAst, dist);
    }

    private static Map.Entry<List<DetailAST>, Integer> searchVariableUsageExpressions(DetailAST variableAst, DetailAST statementAst) {
        ArrayList<DetailAST> variableUsageExpressions = new ArrayList<DetailAST>();
        int distance = 0;
        for (DetailAST currentStatementAst = statementAst; currentStatementAst != null && currentStatementAst.getType() != 73; currentStatementAst = currentStatementAst.getNextSibling()) {
            if (currentStatementAst.getFirstChild() == null) continue;
            if (VariableDeclarationUsageDistanceCheck.isChild(currentStatementAst, variableAst)) {
                variableUsageExpressions.add(currentStatementAst);
                continue;
            }
            if (!variableUsageExpressions.isEmpty() || currentStatementAst.getType() == 10) continue;
            ++distance;
        }
        return new AbstractMap.SimpleEntry<List<DetailAST>, Integer>(variableUsageExpressions, distance);
    }

    private static DetailAST getFirstNodeInsideForWhileDoWhileBlocks(DetailAST block, DetailAST variable) {
        DetailAST firstNodeInsideBlock = null;
        if (!VariableDeclarationUsageDistanceCheck.isVariableInOperatorExpr(block, variable)) {
            DetailAST currentNode = block.getType() == 85 ? block.getFirstChild() : block.findFirstToken(77).getNextSibling();
            int currentNodeType = currentNode.getType();
            if (currentNodeType == 7) {
                firstNodeInsideBlock = currentNode.getFirstChild();
            } else if (currentNodeType != 28) {
                firstNodeInsideBlock = currentNode;
            }
        }
        return firstNodeInsideBlock;
    }

    private static DetailAST getFirstNodeInsideIfBlock(DetailAST block, DetailAST variable) {
        DetailAST firstNodeInsideBlock = null;
        if (!VariableDeclarationUsageDistanceCheck.isVariableInOperatorExpr(block, variable)) {
            DetailAST currentNode = block.getLastChild();
            ArrayList<DetailAST> variableUsageExpressions = new ArrayList<DetailAST>();
            while (currentNode != null && currentNode.getType() == 92) {
                DetailAST previousNode = currentNode.getPreviousSibling();
                if (VariableDeclarationUsageDistanceCheck.isChild(previousNode, variable)) {
                    variableUsageExpressions.add(previousNode);
                }
                if ((currentNode = currentNode.getFirstChild()).getType() == 83) {
                    currentNode = currentNode.getLastChild();
                    continue;
                }
                if (!VariableDeclarationUsageDistanceCheck.isChild(currentNode, variable)) continue;
                variableUsageExpressions.add(currentNode);
                currentNode = null;
            }
            if (currentNode != null && VariableDeclarationUsageDistanceCheck.isChild(currentNode, variable)) {
                variableUsageExpressions.add(currentNode);
            }
            if (variableUsageExpressions.size() == 1) {
                firstNodeInsideBlock = (DetailAST)variableUsageExpressions.get(0);
            }
        }
        return firstNodeInsideBlock;
    }

    private static DetailAST getFirstNodeInsideSwitchBlock(DetailAST block, DetailAST variable) {
        DetailAST currentNode = VariableDeclarationUsageDistanceCheck.getFirstCaseGroupOrSwitchRule(block);
        ArrayList variableUsageExpressions = new ArrayList();
        TokenUtil.forEachChild(block, currentNode.getType(), node -> {
            DetailAST lastNodeInCaseGroup = node.getLastChild();
            if (VariableDeclarationUsageDistanceCheck.isChild(lastNodeInCaseGroup, variable)) {
                variableUsageExpressions.add(lastNodeInCaseGroup);
            }
        });
        DetailAST firstNodeInsideBlock = null;
        if (variableUsageExpressions.size() == 1) {
            firstNodeInsideBlock = (DetailAST)variableUsageExpressions.get(0);
        }
        return firstNodeInsideBlock;
    }

    private static DetailAST getFirstCaseGroupOrSwitchRule(DetailAST block) {
        return Optional.ofNullable(block.findFirstToken(33)).orElse(block.findFirstToken(208));
    }

    private static DetailAST getFirstNodeInsideTryCatchFinallyBlocks(DetailAST block, DetailAST variable) {
        DetailAST finalBlock;
        DetailAST currentNode = block.getFirstChild();
        ArrayList<DetailAST> variableUsageExpressions = new ArrayList<DetailAST>();
        if (VariableDeclarationUsageDistanceCheck.isChild(currentNode, variable)) {
            variableUsageExpressions.add(currentNode);
        }
        for (currentNode = currentNode.getNextSibling(); currentNode != null && currentNode.getType() == 96; currentNode = currentNode.getNextSibling()) {
            DetailAST catchBlock = currentNode.getLastChild();
            if (!VariableDeclarationUsageDistanceCheck.isChild(catchBlock, variable)) continue;
            variableUsageExpressions.add(catchBlock);
        }
        if (currentNode != null && VariableDeclarationUsageDistanceCheck.isChild(finalBlock = currentNode.getLastChild(), variable)) {
            variableUsageExpressions.add(finalBlock);
        }
        DetailAST variableUsageNode = null;
        if (variableUsageExpressions.size() == 1) {
            variableUsageNode = ((DetailAST)variableUsageExpressions.get(0)).getFirstChild();
        }
        return variableUsageNode;
    }

    private static boolean isVariableInOperatorExpr(DetailAST operator, DetailAST variable) {
        DetailAST firstNodeInsideElseBlock;
        DetailAST elseBlock;
        boolean isVarInOperatorDeclaration = false;
        DetailAST openingBracket = operator.findFirstToken(76);
        DetailAST exprBetweenBrackets = openingBracket.getNextSibling();
        while (exprBetweenBrackets.getType() != 77) {
            if (VariableDeclarationUsageDistanceCheck.isChild(exprBetweenBrackets, variable)) {
                isVarInOperatorDeclaration = true;
                break;
            }
            exprBetweenBrackets = exprBetweenBrackets.getNextSibling();
        }
        if (!isVarInOperatorDeclaration && operator.getType() == 83 && (elseBlock = operator.getLastChild()).getType() == 92 && (firstNodeInsideElseBlock = elseBlock.getFirstChild()).getType() == 83) {
            isVarInOperatorDeclaration = VariableDeclarationUsageDistanceCheck.isVariableInOperatorExpr(firstNodeInsideElseBlock, variable);
        }
        return isVarInOperatorDeclaration;
    }

    private static boolean isChild(DetailAST parent, DetailAST ast) {
        boolean isChild = false;
        DetailAST curNode = parent.getFirstChild();
        while (curNode != null) {
            if (curNode.getType() == ast.getType() && curNode.getText().equals(ast.getText())) {
                isChild = true;
                break;
            }
            DetailAST toVisit = curNode.getFirstChild();
            while (toVisit == null) {
                toVisit = curNode.getNextSibling();
                if ((curNode = curNode.getParent()) != parent) continue;
            }
            curNode = toVisit;
        }
        return isChild;
    }

    private boolean isVariableMatchesIgnorePattern(String variable) {
        Matcher matcher = this.ignoreVariablePattern.matcher(variable);
        return matcher.matches();
    }
}

