/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.check;

import com.liferay.source.formatter.checkstyle.check.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.List;

public class CreatingThreadsForDBAccessCheck
extends BaseCheck {
    private static final String _MSG_USE_COMPANY_INHERITABLE_THREAD_LOCAL_CALLABLE = "company.inheritable.thread.local.callable.use";

    public int[] getDefaultTokens() {
        return new int[]{136, 27};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        if (detailAST.getType() == 136) {
            this._checkDBAccessByNewClassInstantiation(detailAST);
        } else {
            this._checkDBAccessByMethodCall(detailAST);
        }
    }

    private void _checkDBAccess(DetailAST detailAST) {
        DetailAST elistDetailAST = detailAST.findFirstToken(34);
        if (elistDetailAST == null) {
            return;
        }
        DetailAST firstChildDetailAST = elistDetailAST.getFirstChild();
        if (firstChildDetailAST == null || firstChildDetailAST.getType() != 181) {
            return;
        }
        List<DetailAST> methodCallDetailASTList = this.getAllChildTokens(firstChildDetailAST, true, 27);
        for (DetailAST methodCallDetailAST : methodCallDetailASTList) {
            String methodCallClassName;
            List<String> names;
            DetailAST dotDetailAST = methodCallDetailAST.findFirstToken(59);
            if (dotDetailAST == null || (names = this.getNames(dotDetailAST, false)).size() != 2 || !(methodCallClassName = names.get(0)).equals("CompanyThreadLocal") && !methodCallClassName.endsWith("LocalService") && !methodCallClassName.endsWith("LocalServiceUtil")) continue;
            this.log(detailAST, _MSG_USE_COMPANY_INHERITABLE_THREAD_LOCAL_CALLABLE, new Object[0]);
        }
    }

    private void _checkDBAccessByMethodCall(DetailAST detailAST) {
        DetailAST dotDetailAST = detailAST.findFirstToken(59);
        if (dotDetailAST == null) {
            return;
        }
        List<String> names = this.getNames(dotDetailAST, false);
        if (names.size() != 2) {
            return;
        }
        String methodCallClassName = names.get(0);
        String methodCallMethodName = names.get(1);
        if (methodCallClassName.equals("DependencyManagerSyncUtil") && methodCallMethodName.equals("registerSyncCallable")) {
            this._checkDBAccess(detailAST);
            return;
        }
        if (Character.isUpperCase(methodCallClassName.charAt(0)) || !methodCallMethodName.equals("submit")) {
            return;
        }
        String variableTypeName = this.getVariableTypeName(detailAST, methodCallClassName, false);
        if (variableTypeName == null || !variableTypeName.endsWith("ExecutorService")) {
            return;
        }
        this._checkDBAccess(detailAST);
    }

    private void _checkDBAccessByNewClassInstantiation(DetailAST detailAST) {
        DetailAST firstChildDetailAST = detailAST.getFirstChild();
        if (firstChildDetailAST == null || firstChildDetailAST.getType() != 58) {
            return;
        }
        String className = firstChildDetailAST.getText();
        if (!className.equals("FutureTask") && !className.equals("Thread")) {
            return;
        }
        this._checkDBAccess(detailAST);
    }
}

