/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.SourceUtil;
import com.liferay.source.formatter.check.util.YMLSourceUtil;
import java.util.ArrayList;

public class YMLIndentationCheck
extends BaseFileCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        return this._checkIndentation(content);
    }

    private String _checkIndentation(String content) {
        String[] lines = content.split("\n");
        if (lines.length == 1) {
            return StringUtil.trimLeading(lines[0]);
        }
        ArrayList<String> definitions = new ArrayList<String>();
        StringBundler sb1 = new StringBundler();
        String leadingSpaces = "";
        int leadingSpacesLength = 0;
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (i == 0) {
                leadingSpaces = SourceUtil.getLeadingSpaces(line);
                leadingSpacesLength = leadingSpaces.length();
                sb1.append(line);
                sb1.append("\n");
                continue;
            }
            if (line.length() == 0 || line.matches(" +")) {
                sb1.append(line);
                sb1.append("\n");
                continue;
            }
            if (line.charAt(leadingSpacesLength) != ' ') {
                if (sb1.index() > 0) {
                    sb1.setIndex(sb1.index() - 1);
                }
                definitions.add(sb1.toString());
                sb1.setIndex(0);
            }
            sb1.append(line);
            sb1.append("\n");
        }
        if (sb1.index() > 0) {
            sb1.setIndex(sb1.index() - 1);
            definitions.add(sb1.toString());
        }
        sb1.setIndex(0);
        for (String definition : definitions) {
            lines = definition.split("\n");
            if (lines.length == 1) {
                sb1.append(StringUtil.trimLeading(definition));
                sb1.append("\n");
                continue;
            }
            String firstLine = lines[0];
            if (YMLSourceUtil.isBlockStyle(firstLine)) {
                sb1.append(StringUtil.trimLeading(firstLine));
                sb1.append("\n");
                if (lines.length == 1) continue;
                for (int i = 1; i < lines.length; ++i) {
                    String line = lines[i];
                    if (i == 1) {
                        leadingSpaces = SourceUtil.getLeadingSpaces(line);
                        leadingSpacesLength = leadingSpaces.length();
                    }
                    if (line.length() == 0 || line.matches(" +")) {
                        sb1.append("\n");
                        continue;
                    }
                    sb1.append("    ");
                    sb1.append(line.substring(leadingSpacesLength));
                    sb1.append("\n");
                }
                continue;
            }
            leadingSpaces = SourceUtil.getLeadingSpaces(firstLine);
            leadingSpacesLength = leadingSpaces.length();
            String subdefinition = definition.substring(firstLine.length() + 1);
            subdefinition = this._checkIndentation(subdefinition);
            lines = subdefinition.split("\n");
            StringBundler sb2 = new StringBundler();
            sb2.append(firstLine.trim());
            sb2.append("\n");
            for (String line : lines) {
                if (line.length() == 0) {
                    sb2.append("");
                } else {
                    sb2.append("    " + line);
                }
                sb2.append("\n");
            }
            if (sb2.index() > 0) {
                sb2.setIndex(sb2.index() - 1);
            }
            sb1.append(sb2.toString());
            sb1.append("\n");
        }
        if (sb1.index() > 0) {
            sb1.setIndex(sb1.index() - 1);
        }
        return sb1.toString();
    }
}

