/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.storage.sugarcrm.internal.rest.manager.v1_0;

import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectField;
import com.liferay.object.rest.dto.v1_0.ObjectEntry;
import com.liferay.object.rest.filter.factory.FilterFactory;
import com.liferay.object.rest.manager.exception.ObjectEntryManagerHttpException;
import com.liferay.object.rest.manager.http.BaseObjectEntryManagerHttp;
import com.liferay.object.rest.manager.http.ObjectEntryManagerHttp;
import com.liferay.object.rest.manager.v1_0.BaseObjectEntryManager;
import com.liferay.object.rest.manager.v1_0.ObjectEntryManager;
import com.liferay.object.storage.sugarcrm.configuration.SugarCRMConfiguration;
import com.liferay.object.storage.sugarcrm.internal.web.cache.SugarCRMAccessTokenWebCacheItem;
import com.liferay.petra.function.UnsafeTriConsumer;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.URLCodec;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"object.entry.manager.storage.type=sugarcrm"}, service={ObjectEntryManager.class})
public class SugarCRMObjectEntryManagerImpl
extends BaseObjectEntryManager
implements ObjectEntryManager {
    @Reference
    private ConfigurationProvider _configurationProvider;
    private final Map<String, String> _defaultObjectFieldNamesToJSONObjectKeys = HashMapBuilder.put((Object)"createDate", (Object)"date_entered").put((Object)"creator", (Object)"created_by").put((Object)"externalReferenceCode", (Object)"id").put((Object)"modifiedDate", (Object)"date_modified").build();
    @Reference(target="(filter.factory.key=sugarcrm)")
    private FilterFactory<String> _filterFactory;
    private final ObjectEntryManagerHttp _objectEntryManagerHttp = new BaseObjectEntryManagerHttp(){

        public JSONObject getAccessToken(long companyId, long groupId) {
            JSONObject jSONObject = SugarCRMAccessTokenWebCacheItem.get(this._getSugarCRMConfiguration(companyId, groupId));
            if (jSONObject == null) {
                throw new ObjectEntryManagerHttpException("Unable to authenticate with SugarCRM");
            }
            return jSONObject;
        }

        public String getBaseURL(long companyId, long groupId) {
            SugarCRMConfiguration sugarCRMConfiguration = this._getSugarCRMConfiguration(companyId, groupId);
            return sugarCRMConfiguration.baseURL();
        }

        private SugarCRMConfiguration _getSugarCRMConfiguration(long companyId, long groupId) {
            try {
                if (groupId == 0L) {
                    return (SugarCRMConfiguration)SugarCRMObjectEntryManagerImpl.this._configurationProvider.getCompanyConfiguration(SugarCRMConfiguration.class, companyId);
                }
                return (SugarCRMConfiguration)SugarCRMObjectEntryManagerImpl.this._configurationProvider.getGroupConfiguration(SugarCRMConfiguration.class, groupId);
            }
            catch (ConfigurationException configurationException) {
                return (SugarCRMConfiguration)ReflectionUtil.throwException((Throwable)configurationException);
            }
        }
    };

    public ObjectEntry addObjectEntry(DTOConverterContext dtoConverterContext, ObjectDefinition objectDefinition, ObjectEntry objectEntry, String scopeKey) throws Exception {
        this.checkPortletResourcePermission("ADD_OBJECT_ENTRY", objectDefinition, scopeKey, dtoConverterContext.getUser());
        JSONObject responseJSONObject = this._objectEntryManagerHttp.post(objectDefinition.getCompanyId(), this.getGroupId(objectDefinition, scopeKey), objectDefinition.getExternalReferenceCode(), this.toJSONObject(dtoConverterContext, objectDefinition, objectEntry, this._getUnsafeTriConsumer(objectDefinition)));
        return this.toObjectEntry(objectDefinition.getCompanyId(), this._getDateFormat(), this._defaultObjectFieldNamesToJSONObjectKeys, dtoConverterContext, responseJSONObject, objectDefinition);
    }

    public void deleteObjectEntry(long companyId, DTOConverterContext dtoConverterContext, String externalReferenceCode, ObjectDefinition objectDefinition, String scopeKey) throws Exception {
        this.checkPortletResourcePermission("DELETE", objectDefinition, scopeKey, dtoConverterContext.getUser());
        this._objectEntryManagerHttp.delete(companyId, this.getGroupId(objectDefinition, scopeKey), objectDefinition.getExternalReferenceCode() + "/" + externalReferenceCode);
    }

    public Page<ObjectEntry> getObjectEntries(long companyId, ObjectDefinition objectDefinition, String scopeKey, Aggregation aggregation, DTOConverterContext dtoConverterContext, String filterString, Pagination pagination, String search, Sort[] sorts) throws Exception {
        this.checkPortletResourcePermission("VIEW", objectDefinition, scopeKey, dtoConverterContext.getUser());
        return this._getObjectEntries(companyId, objectDefinition, scopeKey, dtoConverterContext, filterString, pagination, sorts);
    }

    public ObjectEntry getObjectEntry(long companyId, DTOConverterContext dtoConverterContext, String externalReferenceCode, ObjectDefinition objectDefinition, String scopeKey) throws Exception {
        this.checkPortletResourcePermission("VIEW", objectDefinition, scopeKey, dtoConverterContext.getUser());
        if (Validator.isNull((String)externalReferenceCode)) {
            return null;
        }
        return this.toObjectEntry(companyId, this._getDateFormat(), this._defaultObjectFieldNamesToJSONObjectKeys, dtoConverterContext, this._objectEntryManagerHttp.get(companyId, this.getGroupId(objectDefinition, scopeKey), StringBundler.concat((String[])new String[]{objectDefinition.getExternalReferenceCode(), "/", externalReferenceCode})), objectDefinition);
    }

    public String getStorageLabel(Locale locale) {
        return this.language.get(locale, "sugarcrm");
    }

    public String getStorageType() {
        return "sugarcrm";
    }

    public ObjectEntry updateObjectEntry(long companyId, DTOConverterContext dtoConverterContext, String externalReferenceCode, ObjectDefinition objectDefinition, ObjectEntry objectEntry, String scopeKey) throws Exception {
        this.checkPortletResourcePermission("UPDATE", objectDefinition, scopeKey, dtoConverterContext.getUser());
        if (Validator.isNull((String)externalReferenceCode)) {
            return null;
        }
        JSONObject responseJSONObject = this._objectEntryManagerHttp.put(objectDefinition.getCompanyId(), this.getGroupId(objectDefinition, scopeKey), StringBundler.concat((String[])new String[]{objectDefinition.getExternalReferenceCode(), "/", externalReferenceCode}), this.toJSONObject(dtoConverterContext, objectDefinition, objectEntry, this._getUnsafeTriConsumer(objectDefinition)));
        return this.toObjectEntry(objectDefinition.getCompanyId(), this._getDateFormat(), this._defaultObjectFieldNamesToJSONObjectKeys, dtoConverterContext, responseJSONObject, objectDefinition);
    }

    private void _appendFilter(StringBuilder sb, ObjectDefinition objectDefinition, String filterString) {
        if ((filterString = StringUtil.trim((String)filterString)).isEmpty()) {
            return;
        }
        sb.append("&filter");
        sb.append("=");
        sb.append("[");
        sb.append(URLCodec.encodeURL((String)((String)this._filterFactory.create(filterString, objectDefinition))));
        sb.append("]");
    }

    private void _appendPagination(StringBuilder sb, Pagination pagination) {
        sb.append("&max_num=");
        sb.append(pagination.getPageSize());
        sb.append("&offset=");
        sb.append((pagination.getPage() - 1) * pagination.getPageSize());
    }

    private void _appendSorts(StringBuilder sb, ObjectDefinition objectDefinition, Sort[] sorts) throws Exception {
        if (ArrayUtil.isEmpty((Object[])sorts)) {
            return;
        }
        sb.append("&order_by=");
        List objectFields = this.objectFieldLocalService.getObjectFields(objectDefinition.getObjectDefinitionId());
        for (int i = 0; i < sorts.length; ++i) {
            ObjectField objectField = this.fetchObjectFieldByName(sorts[i].getFieldName(), objectFields);
            if (objectField == null) continue;
            if (i > 0) {
                sb.append(",");
            }
            sb.append(objectField.getExternalReferenceCode());
            sb.append(":");
            if (sorts[i].isReverse()) {
                sb.append("DESC");
                continue;
            }
            sb.append("ASC");
        }
    }

    private DateFormat _getDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX");
    }

    private String _getLocation(ObjectDefinition objectDefinition, String filterString, Pagination pagination, Sort[] sorts, boolean count) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(objectDefinition.getExternalReferenceCode());
        if (count) {
            sb.append("/");
            sb.append("count");
        }
        sb.append("?");
        this._appendFilter(sb, objectDefinition, filterString);
        if (!count) {
            this._appendPagination(sb, pagination);
            this._appendSorts(sb, objectDefinition, sorts);
        }
        return sb.toString();
    }

    private Page<ObjectEntry> _getObjectEntries(long companyId, ObjectDefinition objectDefinition, String scopeKey, DTOConverterContext dtoConverterContext, String filterString, Pagination pagination, Sort[] sorts) throws Exception {
        JSONObject responseJSONObject = this._objectEntryManagerHttp.get(companyId, this.getGroupId(objectDefinition, scopeKey), this._getLocation(objectDefinition, filterString, pagination, sorts, false));
        if (responseJSONObject == null || responseJSONObject.length() == 0) {
            return Page.of(Collections.emptyList());
        }
        return Page.of((Collection)this.toObjectEntries(companyId, this._getDateFormat(), this._defaultObjectFieldNamesToJSONObjectKeys, dtoConverterContext, responseJSONObject.getJSONArray("records"), objectDefinition), (Pagination)pagination, (long)this._getTotalCount(companyId, objectDefinition, scopeKey, filterString, pagination, sorts));
    }

    private int _getTotalCount(long companyId, ObjectDefinition objectDefinition, String scopeKey, String filterString, Pagination pagination, Sort[] sorts) throws Exception {
        JSONObject responseJSONObject = this._objectEntryManagerHttp.get(companyId, this.getGroupId(objectDefinition, scopeKey), this._getLocation(objectDefinition, filterString, pagination, sorts, true));
        return responseJSONObject.getInt("record_count", 0);
    }

    private UnsafeTriConsumer<Map<String, Object>, Object, ObjectField, Exception> _getUnsafeTriConsumer(ObjectDefinition objectDefinition) {
        return (map, value, objectField) -> {
            if (Objects.equals(objectField.getObjectFieldId(), objectDefinition.getTitleObjectFieldId())) {
                map.put("Name", value);
            }
        };
    }
}

