/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.login.web.internal.portlet.action;

import com.liferay.portal.kernel.exception.CompanyMaxUsersException;
import com.liferay.portal.kernel.exception.CookieNotSupportedException;
import com.liferay.portal.kernel.exception.NoSuchUserException;
import com.liferay.portal.kernel.exception.PasswordExpiredException;
import com.liferay.portal.kernel.exception.UserEmailAddressException;
import com.liferay.portal.kernel.exception.UserIdException;
import com.liferay.portal.kernel.exception.UserLockoutException;
import com.liferay.portal.kernel.exception.UserPasswordException;
import com.liferay.portal.kernel.exception.UserScreenNameException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.security.auth.AuthException;
import com.liferay.portal.kernel.security.auth.session.AuthenticatedSessionManager;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.URLCodec;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"javax.portlet.name=com_liferay_login_web_portlet_FastLoginPortlet", "javax.portlet.name=com_liferay_login_web_portlet_LoginPortlet", "mvc.command.name=/login/login"}, service={MVCActionCommand.class})
public class LoginMVCActionCommand
extends BaseMVCActionCommand {
    private static final Log _log = LogFactoryUtil.getLog(LoginMVCActionCommand.class);
    @Reference
    private AuthenticatedSessionManager _authenticatedSessionManager;
    @Reference
    private Portal _portal;

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (PropsValues.AUTH_LOGIN_DISABLED) {
            actionResponse.sendRedirect(themeDisplay.getPathMain() + PropsValues.AUTH_LOGIN_DISABLED_PATH);
            return;
        }
        try {
            this.login(themeDisplay, actionRequest, actionResponse);
            boolean doActionAfterLogin = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"doActionAfterLogin");
            if (doActionAfterLogin) {
                LiferayPortletResponse liferayPortletResponse = this._portal.getLiferayPortletResponse((PortletResponse)actionResponse);
                PortletURL renderURL = liferayPortletResponse.createRenderURL();
                renderURL.setParameter("mvcRenderCommandName", "/login/login_redirect");
                actionRequest.setAttribute("REDIRECT", (Object)renderURL.toString());
            }
        }
        catch (Exception e) {
            if (e instanceof AuthException) {
                Throwable cause = e.getCause();
                if (cause instanceof PasswordExpiredException || cause instanceof UserLockoutException) {
                    SessionErrors.add((PortletRequest)actionRequest, cause.getClass(), (Object)cause);
                } else {
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)"Authentication failed");
                    }
                    SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                }
            } else if (e instanceof CompanyMaxUsersException || e instanceof CookieNotSupportedException || e instanceof NoSuchUserException || e instanceof PasswordExpiredException || e instanceof UserEmailAddressException || e instanceof UserIdException || e instanceof UserLockoutException || e instanceof UserPasswordException || e instanceof UserScreenNameException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass(), (Object)e);
            } else {
                _log.error((Object)e, (Throwable)e);
                this._portal.sendError(e, actionRequest, actionResponse);
                return;
            }
            this.postProcessAuthFailure(actionRequest, actionResponse);
        }
    }

    protected String getCompleteRedirectURL(HttpServletRequest request, String redirect) {
        HttpSession session = request.getSession();
        Boolean httpsInitial = (Boolean)session.getAttribute("HTTPS_INITIAL");
        String portalURL = null;
        portalURL = PropsValues.COMPANY_SECURITY_AUTH_REQUIRES_HTTPS && !PropsValues.SESSION_ENABLE_PHISHING_PROTECTION && httpsInitial != null && httpsInitial == false ? this._portal.getPortalURL(request, false) : this._portal.getPortalURL(request);
        return portalURL.concat(redirect);
    }

    protected void login(ThemeDisplay themeDisplay, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String redirect;
        HttpServletRequest request = this._portal.getOriginalServletRequest(this._portal.getHttpServletRequest((PortletRequest)actionRequest));
        HttpServletResponse response = this._portal.getHttpServletResponse((PortletResponse)actionResponse);
        String login = ParamUtil.getString((PortletRequest)actionRequest, (String)"login");
        String password = actionRequest.getParameter("password");
        boolean rememberMe = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"rememberMe");
        if (!themeDisplay.isSignedIn()) {
            String portletId = this._portal.getPortletId((PortletRequest)actionRequest);
            PortletPreferences portletPreferences = PortletPreferencesFactoryUtil.getStrictPortletSetup((Layout)themeDisplay.getLayout(), (String)portletId);
            String authType = portletPreferences.getValue("authType", null);
            this._authenticatedSessionManager.login(request, response, login, password, rememberMe, authType);
        }
        if (Validator.isNotNull((String)(redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect")))) {
            if (!themeDisplay.isSignedIn()) {
                LiferayPortletResponse liferayPortletResponse = this._portal.getLiferayPortletResponse((PortletResponse)actionResponse);
                String portletId = this._portal.getPortletId((PortletRequest)actionRequest);
                LiferayPortletURL actionURL = liferayPortletResponse.createActionURL(portletId);
                actionURL.setParameter("javax.portlet.action", "/login/login");
                actionURL.setParameter("redirect", redirect);
                actionRequest.setAttribute("REDIRECT", (Object)actionURL.toString());
                return;
            }
            if (Validator.isNotNull((String)(redirect = this._portal.escapeRedirect(redirect))) && !redirect.startsWith("http")) {
                redirect = this.getCompleteRedirectURL(request, redirect);
            }
        }
        String mainPath = themeDisplay.getPathMain();
        if (PropsValues.PORTAL_JAAS_ENABLE) {
            redirect = Validator.isNotNull((String)redirect) ? mainPath.concat("/portal/protected?redirect=").concat(URLCodec.encodeURL((String)redirect)) : mainPath.concat("/portal/protected");
            actionResponse.sendRedirect(redirect);
        } else if (Validator.isNotNull((String)redirect)) {
            actionResponse.sendRedirect(redirect);
        } else {
            boolean doActionAfterLogin = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"doActionAfterLogin");
            if (doActionAfterLogin) {
                return;
            }
            actionResponse.sendRedirect(mainPath);
        }
    }

    protected void postProcessAuthFailure(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String login;
        LiferayPortletRequest liferayPortletRequest = this._portal.getLiferayPortletRequest((PortletRequest)actionRequest);
        String portletName = liferayPortletRequest.getPortletName();
        Layout layout = (Layout)actionRequest.getAttribute("LAYOUT");
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create((PortletRequest)actionRequest, (Portlet)liferayPortletRequest.getPortlet(), (Layout)layout, (String)"RENDER_PHASE");
        portletURL.setParameter("saveLastPath", Boolean.FALSE.toString());
        String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
        if (Validator.isNotNull((String)redirect)) {
            portletURL.setParameter("redirect", redirect);
        }
        if (Validator.isNotNull((String)(login = ParamUtil.getString((PortletRequest)actionRequest, (String)"login")))) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"login", (Object)login);
        }
        if (portletName.equals("com_liferay_login_web_portlet_LoginPortlet")) {
            portletURL.setWindowState(WindowState.MAXIMIZED);
        } else {
            portletURL.setWindowState(actionRequest.getWindowState());
        }
        actionResponse.sendRedirect(portletURL.toString());
    }
}

