/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.login.web.internal.portlet.action;

import com.liferay.captcha.configuration.CaptchaConfiguration;
import com.liferay.captcha.util.CaptchaUtil;
import com.liferay.login.web.internal.portlet.util.LoginUtil;
import com.liferay.portal.kernel.captcha.CaptchaConfigurationException;
import com.liferay.portal.kernel.captcha.CaptchaException;
import com.liferay.portal.kernel.captcha.CaptchaTextException;
import com.liferay.portal.kernel.exception.NoSuchUserException;
import com.liferay.portal.kernel.exception.RequiredReminderQueryException;
import com.liferay.portal.kernel.exception.SendPasswordException;
import com.liferay.portal.kernel.exception.UserActiveException;
import com.liferay.portal.kernel.exception.UserEmailAddressException;
import com.liferay.portal.kernel.exception.UserLockoutException;
import com.liferay.portal.kernel.exception.UserReminderQueryException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"javax.portlet.name=com_liferay_login_web_portlet_FastLoginPortlet", "javax.portlet.name=com_liferay_login_web_portlet_LoginPortlet", "mvc.command.name=/login/forgot_password"}, service={MVCActionCommand.class})
public class ForgotPasswordMVCActionCommand
extends BaseMVCActionCommand {
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private Portal _portal;
    private UserLocalService _userLocalService;

    protected void checkCaptcha(ActionRequest actionRequest) throws CaptchaConfigurationException, CaptchaException {
        CaptchaConfiguration captchaConfiguration = this.getCaptchaConfiguration();
        if (captchaConfiguration.sendPasswordCaptchaEnabled()) {
            CaptchaUtil.check((PortletRequest)actionRequest);
        }
    }

    protected void checkReminderQueries(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        PortletSession portletSession = actionRequest.getPortletSession();
        int step = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"step");
        if (step == 1) {
            this.checkCaptcha(actionRequest);
            portletSession.removeAttribute("FORGOT_PASSWORD_REMINDER_ATTEMPTS");
            portletSession.removeAttribute("FORGOT_PASSWORD_REMINDER_USER_EMAIL_ADDRESS");
        }
        User user = this.getUser(actionRequest);
        portletSession.setAttribute("FORGOT_PASSWORD_REMINDER_USER_EMAIL_ADDRESS", (Object)user.getEmailAddress());
        actionRequest.setAttribute("FORGOT_PASSWORD_REMINDER_USER", (Object)user);
        if (step == 2) {
            Integer reminderAttempts = (Integer)portletSession.getAttribute("FORGOT_PASSWORD_REMINDER_ATTEMPTS");
            if (reminderAttempts == null) {
                reminderAttempts = 0;
            } else if (reminderAttempts > 2) {
                this.checkCaptcha(actionRequest);
            }
            Integer n = reminderAttempts;
            Integer n2 = reminderAttempts = Integer.valueOf(reminderAttempts + 1);
            portletSession.setAttribute("FORGOT_PASSWORD_REMINDER_ATTEMPTS", (Object)reminderAttempts);
            this.sendPassword(actionRequest, actionResponse);
        }
    }

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Company company = themeDisplay.getCompany();
        if (!company.isSendPassword() && !company.isSendPasswordResetLink()) {
            throw new PrincipalException.MustBeEnabled(company.getCompanyId(), new String[]{"company.security.send.password", "company.security.send.password.reset.link"});
        }
        try {
            if (PropsValues.USERS_REMINDER_QUERIES_ENABLED) {
                this.checkReminderQueries(actionRequest, actionResponse);
            } else {
                this.checkCaptcha(actionRequest);
                this.sendPassword(actionRequest, actionResponse);
            }
        }
        catch (Exception e) {
            if (e instanceof CaptchaConfigurationException || e instanceof CaptchaTextException || e instanceof UserEmailAddressException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            }
            if (e instanceof NoSuchUserException || e instanceof RequiredReminderQueryException || e instanceof SendPasswordException || e instanceof UserActiveException || e instanceof UserLockoutException || e instanceof UserReminderQueryException) {
                if (PropsValues.LOGIN_SECURE_FORGOT_PASSWORD) {
                    this.sendRedirect(actionRequest, actionResponse, null);
                } else {
                    SessionErrors.add((PortletRequest)actionRequest, e.getClass(), (Object)e);
                }
            }
            this._portal.sendError(e, actionRequest, actionResponse);
        }
    }

    protected CaptchaConfiguration getCaptchaConfiguration() throws CaptchaConfigurationException {
        try {
            return (CaptchaConfiguration)this._configurationProvider.getSystemConfiguration(CaptchaConfiguration.class);
        }
        catch (Exception e) {
            throw new CaptchaConfigurationException((Throwable)e);
        }
    }

    protected User getUser(ActionRequest actionRequest) throws Exception {
        PortletSession portletSession = actionRequest.getPortletSession();
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String sessionEmailAddress = (String)portletSession.getAttribute("FORGOT_PASSWORD_REMINDER_USER_EMAIL_ADDRESS");
        User user = null;
        if (Validator.isNotNull((String)sessionEmailAddress)) {
            user = this._userLocalService.getUserByEmailAddress(themeDisplay.getCompanyId(), sessionEmailAddress);
        } else {
            long userId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"userId");
            String screenName = ParamUtil.getString((PortletRequest)actionRequest, (String)"screenName");
            String emailAddress = ParamUtil.getString((PortletRequest)actionRequest, (String)"emailAddress");
            if (Validator.isNotNull((String)emailAddress)) {
                user = this._userLocalService.getUserByEmailAddress(themeDisplay.getCompanyId(), emailAddress);
            } else if (Validator.isNotNull((String)screenName)) {
                user = this._userLocalService.getUserByScreenName(themeDisplay.getCompanyId(), screenName);
            } else if (userId > 0L) {
                user = this._userLocalService.getUserById(userId);
            } else {
                throw new NoSuchUserException("User does not exist");
            }
        }
        if (!user.isActive()) {
            throw new UserActiveException("Inactive user " + user.getUuid());
        }
        this._userLocalService.checkLockout(user);
        return user;
    }

    protected void sendPassword(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Company company = themeDisplay.getCompany();
        User user = this.getUser(actionRequest);
        if (PropsValues.USERS_REMINDER_QUERIES_ENABLED) {
            if (PropsValues.USERS_REMINDER_QUERIES_REQUIRED && !user.hasReminderQuery()) {
                throw new RequiredReminderQueryException("No reminder query or answer is defined for user " + user.getUserId());
            }
            String answer = ParamUtil.getString((PortletRequest)actionRequest, (String)"answer");
            String reminderQueryAnswer = user.getReminderQueryAnswer();
            if (!reminderQueryAnswer.equals(answer)) {
                throw new UserReminderQueryException("Reminder query answer does not match answer");
            }
        }
        PortletPreferences portletPreferences = actionRequest.getPreferences();
        String languageId = LanguageUtil.getLanguageId((PortletRequest)actionRequest);
        String emailFromName = portletPreferences.getValue("emailFromName", null);
        String emailFromAddress = portletPreferences.getValue("emailFromAddress", null);
        String emailToAddress = user.getEmailAddress();
        String emailParam = "emailPasswordSent";
        if (company.isSendPasswordResetLink()) {
            emailParam = "emailPasswordReset";
        }
        String subject = portletPreferences.getValue(emailParam + "Subject_" + languageId, null);
        String body = portletPreferences.getValue(emailParam + "Body_" + languageId, null);
        LoginUtil.sendPassword(actionRequest, emailFromName, emailFromAddress, emailToAddress, subject, body);
        HttpServletRequest request = this._portal.getHttpServletRequest((PortletRequest)actionRequest);
        SessionMessages.add((HttpServletRequest)request, (String)"passwordSent");
        this.sendRedirect(actionRequest, actionResponse, null);
    }

    @Reference(unbind="-")
    protected void setUserLocalService(UserLocalService userLocalService) {
        this._userLocalService = userLocalService;
    }
}

