/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.login.web.internal.portlet.action;

import com.liferay.captcha.configuration.CaptchaConfiguration;
import com.liferay.captcha.util.CaptchaUtil;
import com.liferay.portal.kernel.captcha.CaptchaConfigurationException;
import com.liferay.portal.kernel.captcha.CaptchaTextException;
import com.liferay.portal.kernel.exception.CompanyMaxUsersException;
import com.liferay.portal.kernel.exception.ContactNameException;
import com.liferay.portal.kernel.exception.EmailAddressException;
import com.liferay.portal.kernel.exception.GroupFriendlyURLException;
import com.liferay.portal.kernel.exception.UserEmailAddressException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.portlet.JSONPortletResponseUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.UserService;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import java.io.Serializable;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"javax.portlet.name=com_liferay_login_web_portlet_FastLoginPortlet", "javax.portlet.name=com_liferay_login_web_portlet_LoginPortlet", "mvc.command.name=/login/create_anonymous_account"}, service={MVCActionCommand.class})
public class CreateAnonymousAccountMVCActionCommand
extends BaseMVCActionCommand {
    private static final Log _log = LogFactoryUtil.getLog(CreateAnonymousAccountMVCActionCommand.class);
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private Portal _portal;
    private UserLocalService _userLocalService;
    private UserService _userService;

    protected void addAnonymousUser(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        HttpServletRequest request = this._portal.getHttpServletRequest((PortletRequest)actionRequest);
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        boolean autoPassword = true;
        String password1 = null;
        String password2 = null;
        boolean autoScreenName = true;
        String screenName = null;
        String emailAddress = ParamUtil.getString((PortletRequest)actionRequest, (String)"emailAddress");
        long facebookId = 0L;
        String openId = "";
        String firstName = ParamUtil.getString((PortletRequest)actionRequest, (String)"firstName");
        String lastName = ParamUtil.getString((PortletRequest)actionRequest, (String)"lastName");
        long prefixId = 0L;
        long suffixId = 0L;
        boolean male = true;
        int birthdayMonth = 0;
        int birthdayDay = 1;
        int birthdayYear = 1970;
        String jobTitle = null;
        long[] groupIds = null;
        long[] organizationIds = null;
        long[] roleIds = null;
        long[] userGroupIds = null;
        boolean sendEmail = false;
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)User.class.getName(), (PortletRequest)actionRequest);
        serviceContext.setAttribute("anonymousUser", (Serializable)Boolean.TRUE);
        CaptchaConfiguration captchaConfiguration = this.getCaptchaConfiguration();
        if (captchaConfiguration.createAccountCaptchaEnabled()) {
            CaptchaUtil.check((PortletRequest)actionRequest);
        }
        serviceContext.setWorkflowAction(2);
        User user = this._userService.addUser(themeDisplay.getCompanyId(), autoPassword, password1, password2, autoScreenName, screenName, emailAddress, facebookId, openId, themeDisplay.getLocale(), firstName, null, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, jobTitle, groupIds, organizationIds, roleIds, userGroupIds, sendEmail, serviceContext);
        this._userLocalService.updateStatus(user.getUserId(), 6, new ServiceContext());
        SessionMessages.add((HttpServletRequest)request, (String)"userAdded", (Object)user.getEmailAddress());
        SessionMessages.add((HttpServletRequest)request, (String)"userAddedPassword", (Object)user.getPasswordUnencrypted());
    }

    protected void addSuccessMessage(ActionRequest actionRequest, ActionResponse actionResponse) {
        String portletId = (String)actionRequest.getAttribute("PORTLET_ID");
        if (!portletId.equals("com_liferay_login_web_portlet_FastLoginPortlet")) {
            super.addSuccessMessage(actionRequest, actionResponse);
        }
    }

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletConfig portletConfig = (PortletConfig)actionRequest.getAttribute("javax.portlet.config");
        String portletName = portletConfig.getPortletName();
        if (!portletName.equals("com_liferay_login_web_portlet_FastLoginPortlet")) {
            throw new PrincipalException("Unable to create anonymous account");
        }
        if (actionRequest.getRemoteUser() != null) {
            actionResponse.sendRedirect(themeDisplay.getPathMain());
            return;
        }
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        String emailAddress = ParamUtil.getString((PortletRequest)actionRequest, (String)"emailAddress");
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create((PortletRequest)actionRequest, (String)"com_liferay_login_web_portlet_FastLoginPortlet", (String)"RENDER_PHASE");
        portletURL.setParameter("mvcRenderCommandName", "/login/login_redirect");
        portletURL.setParameter("emailAddress", emailAddress);
        portletURL.setParameter("anonymousUser", Boolean.TRUE.toString());
        portletURL.setWindowState(LiferayWindowState.POP_UP);
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        try {
            if (cmd.equals("add")) {
                this.addAnonymousUser(actionRequest, actionResponse);
                this.sendRedirect(actionRequest, actionResponse, portletURL.toString());
            } else if (cmd.equals("update")) {
                Company company = themeDisplay.getCompany();
                if (!company.isStrangers()) {
                    throw new PrincipalException.MustBeEnabled(company.getCompanyId(), new String[]{"company.security.strangers"});
                }
                jsonObject = this.updateIncompleteUser(actionRequest, actionResponse);
                JSONPortletResponseUtil.writeJSON((PortletRequest)actionRequest, (PortletResponse)actionResponse, (Object)jsonObject);
            }
        }
        catch (Exception e) {
            if (cmd.equals("update")) {
                jsonObject.putException(e);
                JSONPortletResponseUtil.writeJSON((PortletRequest)actionRequest, (PortletResponse)actionResponse, (Object)jsonObject);
            }
            if (e instanceof UserEmailAddressException.MustNotBeDuplicate) {
                User user = this._userLocalService.getUserByEmailAddress(themeDisplay.getCompanyId(), emailAddress);
                if (user.getStatus() != 6) {
                    SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                } else {
                    this.sendRedirect(actionRequest, actionResponse, portletURL.toString());
                }
            }
            if (e instanceof CaptchaConfigurationException || e instanceof CaptchaTextException || e instanceof CompanyMaxUsersException || e instanceof ContactNameException || e instanceof EmailAddressException || e instanceof GroupFriendlyURLException || e instanceof UserEmailAddressException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass(), (Object)e);
            }
            _log.error((Object)"Unable to create anonymous account", (Throwable)e);
            this._portal.sendError(e, actionRequest, actionResponse);
        }
    }

    protected CaptchaConfiguration getCaptchaConfiguration() throws CaptchaConfigurationException {
        try {
            return (CaptchaConfiguration)this._configurationProvider.getSystemConfiguration(CaptchaConfiguration.class);
        }
        catch (Exception e) {
            throw new CaptchaConfigurationException((Throwable)e);
        }
    }

    @Reference(unbind="-")
    protected void setUserLocalService(UserLocalService userLocalService) {
        this._userLocalService = userLocalService;
    }

    @Reference(unbind="-")
    protected void setUserService(UserService userService) {
        this._userService = userService;
    }

    protected JSONObject updateIncompleteUser(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)User.class.getName(), (PortletRequest)actionRequest);
        boolean autoPassword = true;
        String password1 = null;
        String password2 = null;
        boolean autoScreenName = false;
        String screenName = null;
        String emailAddress = ParamUtil.getString((PortletRequest)actionRequest, (String)"emailAddress");
        long facebookId = 0L;
        String openId = null;
        String firstName = null;
        String middleName = null;
        String lastName = null;
        long prefixId = 0L;
        long suffixId = 0L;
        boolean male = true;
        int birthdayMonth = 0;
        int birthdayDay = 1;
        int birthdayYear = 1970;
        String jobTitle = null;
        boolean updateUserInformation = false;
        boolean sendEmail = true;
        User user = this._userService.updateIncompleteUser(themeDisplay.getCompanyId(), autoPassword, password1, password2, autoScreenName, screenName, emailAddress, facebookId, openId, themeDisplay.getLocale(), firstName, middleName, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, jobTitle, updateUserInformation, sendEmail, serviceContext);
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        if (user.getStatus() == 0) {
            jsonObject.put("userStatus", "user_added");
        } else {
            jsonObject.put("userStatus", "user_pending");
        }
        return jsonObject;
    }
}

