/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.login.web.internal.portlet.action;

import com.liferay.captcha.configuration.CaptchaConfiguration;
import com.liferay.captcha.util.CaptchaUtil;
import com.liferay.login.web.internal.portlet.util.LoginUtil;
import com.liferay.portal.kernel.captcha.CaptchaConfigurationException;
import com.liferay.portal.kernel.captcha.CaptchaTextException;
import com.liferay.portal.kernel.exception.AddressCityException;
import com.liferay.portal.kernel.exception.AddressStreetException;
import com.liferay.portal.kernel.exception.AddressZipException;
import com.liferay.portal.kernel.exception.CompanyMaxUsersException;
import com.liferay.portal.kernel.exception.ContactBirthdayException;
import com.liferay.portal.kernel.exception.ContactNameException;
import com.liferay.portal.kernel.exception.DuplicateOpenIdException;
import com.liferay.portal.kernel.exception.EmailAddressException;
import com.liferay.portal.kernel.exception.GroupFriendlyURLException;
import com.liferay.portal.kernel.exception.NoSuchCountryException;
import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.exception.NoSuchListTypeException;
import com.liferay.portal.kernel.exception.NoSuchOrganizationException;
import com.liferay.portal.kernel.exception.NoSuchRegionException;
import com.liferay.portal.kernel.exception.OrganizationParentException;
import com.liferay.portal.kernel.exception.PhoneNumberException;
import com.liferay.portal.kernel.exception.RequiredFieldException;
import com.liferay.portal.kernel.exception.RequiredUserException;
import com.liferay.portal.kernel.exception.TermsOfUseException;
import com.liferay.portal.kernel.exception.UserEmailAddressException;
import com.liferay.portal.kernel.exception.UserIdException;
import com.liferay.portal.kernel.exception.UserPasswordException;
import com.liferay.portal.kernel.exception.UserScreenNameException;
import com.liferay.portal.kernel.exception.UserSmsException;
import com.liferay.portal.kernel.exception.WebsiteURLException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.ListType;
import com.liferay.portal.kernel.model.ListTypeConstants;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.portlet.DynamicActionRequest;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.auth.session.AuthenticatedSessionManager;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.ListTypeLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.UserService;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PwdGenerator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"javax.portlet.name=com_liferay_login_web_portlet_FastLoginPortlet", "javax.portlet.name=com_liferay_login_web_portlet_LoginPortlet", "mvc.command.name=/login/create_account"}, service={MVCActionCommand.class})
public class CreateAccountMVCActionCommand
extends BaseMVCActionCommand {
    private static final boolean _AUTO_SCREEN_NAME = false;
    private static final Log _log = LogFactoryUtil.getLog(CreateAccountMVCActionCommand.class);
    @Reference
    private AuthenticatedSessionManager _authenticatedSessionManager;
    @Reference
    private ConfigurationProvider _configurationProvider;
    private LayoutLocalService _layoutLocalService;
    @Reference
    private ListTypeLocalService _listTypeLocalService;
    @Reference
    private Portal _portal;
    private UserLocalService _userLocalService;
    private UserService _userService;

    protected void addUser(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        HttpServletRequest request = this._portal.getHttpServletRequest((PortletRequest)actionRequest);
        HttpSession session = request.getSession();
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Company company = themeDisplay.getCompany();
        boolean autoPassword = true;
        String password1 = null;
        String password2 = null;
        boolean autoScreenName = this.isAutoScreenName();
        String screenName = ParamUtil.getString((PortletRequest)actionRequest, (String)"screenName");
        String emailAddress = ParamUtil.getString((PortletRequest)actionRequest, (String)"emailAddress");
        long facebookId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"facebookId");
        String openId = ParamUtil.getString((PortletRequest)actionRequest, (String)"openId");
        String languageId = ParamUtil.getString((PortletRequest)actionRequest, (String)"languageId");
        String firstName = ParamUtil.getString((PortletRequest)actionRequest, (String)"firstName");
        String middleName = ParamUtil.getString((PortletRequest)actionRequest, (String)"middleName");
        String lastName = ParamUtil.getString((PortletRequest)actionRequest, (String)"lastName");
        long prefixId = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"prefixId");
        long suffixId = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"suffixId");
        boolean male = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"male", (boolean)true);
        int birthdayMonth = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"birthdayMonth");
        int birthdayDay = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"birthdayDay");
        int birthdayYear = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"birthdayYear");
        String jobTitle = ParamUtil.getString((PortletRequest)actionRequest, (String)"jobTitle");
        long[] groupIds = null;
        long[] organizationIds = null;
        long[] roleIds = null;
        long[] userGroupIds = null;
        boolean sendEmail = true;
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)User.class.getName(), (PortletRequest)actionRequest);
        if (PropsValues.LOGIN_CREATE_ACCOUNT_ALLOW_CUSTOM_PASSWORD) {
            autoPassword = false;
            password1 = ParamUtil.getString((PortletRequest)actionRequest, (String)"password1");
            password2 = ParamUtil.getString((PortletRequest)actionRequest, (String)"password2");
        }
        boolean openIdPending = false;
        Boolean openIdLoginPending = (Boolean)session.getAttribute("OPEN_ID_LOGIN_PENDING");
        if (openIdLoginPending != null && openIdLoginPending.booleanValue() && Validator.isNotNull((String)openId)) {
            sendEmail = false;
            openIdPending = true;
        }
        User user = this._userService.addUserWithWorkflow(company.getCompanyId(), autoPassword, password1, password2, autoScreenName, screenName, emailAddress, facebookId, openId, LocaleUtil.fromLanguageId((String)languageId), firstName, middleName, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, jobTitle, groupIds, organizationIds, roleIds, userGroupIds, sendEmail, serviceContext);
        if (openIdPending) {
            session.setAttribute("OPEN_ID_LOGIN", (Object)user.getUserId());
            session.removeAttribute("OPEN_ID_LOGIN_PENDING");
        } else if (user.getStatus() == 0) {
            SessionMessages.add((HttpServletRequest)request, (String)"userAdded", (Object)user.getEmailAddress());
            SessionMessages.add((HttpServletRequest)request, (String)"userAddedPassword", (Object)user.getPasswordUnencrypted());
        } else {
            SessionMessages.add((HttpServletRequest)request, (String)"userPending", (Object)user.getEmailAddress());
        }
        this.sendRedirect(actionRequest, actionResponse, themeDisplay, user, user.getPasswordUnencrypted());
    }

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        block16: {
            ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            Company company = themeDisplay.getCompany();
            if (!company.isStrangers()) {
                throw new PrincipalException.MustBeEnabled(company.getCompanyId(), new String[]{"company.security.strangers"});
            }
            actionRequest = this._wrapActionRequest(actionRequest);
            String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
            try {
                if (cmd.equals("add")) {
                    CaptchaConfiguration captchaConfiguration = this.getCaptchaConfiguration();
                    if (captchaConfiguration.createAccountCaptchaEnabled()) {
                        CaptchaUtil.check((PortletRequest)actionRequest);
                    }
                    this.addUser(actionRequest, actionResponse);
                } else if (cmd.equals("reset")) {
                    this.resetUser(actionRequest, actionResponse);
                } else if (cmd.equals("update")) {
                    this.updateIncompleteUser(actionRequest, actionResponse);
                }
            }
            catch (Exception e) {
                if (e instanceof UserEmailAddressException.MustNotBeDuplicate || e instanceof UserScreenNameException.MustNotBeDuplicate) {
                    String emailAddress = ParamUtil.getString((PortletRequest)actionRequest, (String)"emailAddress");
                    User user = this._userLocalService.fetchUserByEmailAddress(themeDisplay.getCompanyId(), emailAddress);
                    if (user == null || user.getStatus() != 6) {
                        SessionErrors.add((PortletRequest)actionRequest, e.getClass(), (Object)e);
                    } else {
                        actionResponse.setRenderParameter("mvcPath", "/update_account.jsp");
                    }
                }
                if (e instanceof AddressCityException || e instanceof AddressStreetException || e instanceof AddressZipException || e instanceof CaptchaConfigurationException || e instanceof CaptchaTextException || e instanceof CompanyMaxUsersException || e instanceof ContactBirthdayException || e instanceof ContactNameException || e instanceof DuplicateOpenIdException || e instanceof EmailAddressException || e instanceof GroupFriendlyURLException || e instanceof NoSuchCountryException || e instanceof NoSuchListTypeException || e instanceof NoSuchOrganizationException || e instanceof NoSuchRegionException || e instanceof OrganizationParentException || e instanceof PhoneNumberException || e instanceof RequiredFieldException || e instanceof RequiredUserException || e instanceof TermsOfUseException || e instanceof UserEmailAddressException || e instanceof UserIdException || e instanceof UserPasswordException || e instanceof UserScreenNameException || e instanceof UserSmsException || e instanceof WebsiteURLException) {
                    SessionErrors.add((PortletRequest)actionRequest, e.getClass(), (Object)e);
                }
                throw e;
            }
            if (Validator.isNull((String)PropsValues.COMPANY_SECURITY_STRANGERS_URL)) {
                return;
            }
            try {
                Layout layout = this._layoutLocalService.getFriendlyURLLayout(themeDisplay.getScopeGroupId(), false, PropsValues.COMPANY_SECURITY_STRANGERS_URL);
                String redirect = this._portal.getLayoutURL(layout, themeDisplay);
                this.sendRedirect(actionRequest, actionResponse, redirect);
            }
            catch (NoSuchLayoutException nsle) {
                if (!_log.isDebugEnabled()) break block16;
                _log.debug((Object)nsle, (Throwable)nsle);
            }
        }
    }

    protected CaptchaConfiguration getCaptchaConfiguration() throws CaptchaConfigurationException {
        try {
            return (CaptchaConfiguration)this._configurationProvider.getSystemConfiguration(CaptchaConfiguration.class);
        }
        catch (Exception e) {
            throw new CaptchaConfigurationException((Throwable)e);
        }
    }

    protected long getListTypeId(PortletRequest portletRequest, String parameterName, String type) throws Exception {
        String parameterValue = ParamUtil.getString((PortletRequest)portletRequest, (String)parameterName);
        ListType listType = this._listTypeLocalService.addListType(parameterValue, type);
        return listType.getListTypeId();
    }

    protected boolean isAutoScreenName() {
        return false;
    }

    protected void resetUser(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String emailAddress = ParamUtil.getString((PortletRequest)actionRequest, (String)"emailAddress");
        User anonymousUser = this._userLocalService.getUserByEmailAddress(themeDisplay.getCompanyId(), emailAddress);
        if (anonymousUser.getStatus() != 6) {
            throw new PrincipalException.MustBeAuthenticated(anonymousUser.getUuid());
        }
        this._userLocalService.deleteUser(anonymousUser.getUserId());
        this.addUser(actionRequest, actionResponse);
    }

    protected void sendRedirect(ActionRequest actionRequest, ActionResponse actionResponse, ThemeDisplay themeDisplay, User user, String password) throws Exception {
        String login = null;
        Company company = themeDisplay.getCompany();
        String authType = company.getAuthType();
        login = authType.equals("userId") ? String.valueOf(user.getUserId()) : (authType.equals("screenName") ? user.getScreenName() : user.getEmailAddress());
        HttpServletRequest request = this._portal.getHttpServletRequest((PortletRequest)actionRequest);
        String redirect = this._portal.escapeRedirect(ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect"));
        if (Validator.isNotNull((String)redirect)) {
            HttpServletResponse response = this._portal.getHttpServletResponse((PortletResponse)actionResponse);
            this._authenticatedSessionManager.login(request, response, login, password, false, null);
        } else {
            PortletURL loginURL = LoginUtil.getLoginURL(request, themeDisplay.getPlid());
            loginURL.setParameter("login", login);
            redirect = loginURL.toString();
        }
        actionResponse.sendRedirect(redirect);
    }

    @Reference(unbind="-")
    protected void setLayoutLocalService(LayoutLocalService layoutLocalService) {
        this._layoutLocalService = layoutLocalService;
    }

    @Reference(unbind="-")
    protected void setUserLocalService(UserLocalService userLocalService) {
        this._userLocalService = userLocalService;
    }

    @Reference(unbind="-")
    protected void setUserService(UserService userService) {
        this._userService = userService;
    }

    protected void updateIncompleteUser(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        HttpServletRequest request = this._portal.getOriginalServletRequest(this._portal.getHttpServletRequest((PortletRequest)actionRequest));
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        boolean autoPassword = true;
        String password1 = null;
        String password2 = null;
        boolean autoScreenName = false;
        String screenName = ParamUtil.getString((PortletRequest)actionRequest, (String)"screenName");
        String emailAddress = ParamUtil.getString((PortletRequest)actionRequest, (String)"emailAddress");
        HttpSession session = request.getSession();
        long facebookId = GetterUtil.getLong((Object)session.getAttribute("FACEBOOK_INCOMPLETE_USER_ID"));
        String googleUserId = GetterUtil.getString((Object)session.getAttribute("GOOGLE_INCOMPLETE_USER_ID"));
        if (Validator.isNotNull((String)googleUserId)) {
            autoPassword = false;
        }
        if (facebookId > 0L || Validator.isNotNull((String)googleUserId)) {
            password2 = password1 = PwdGenerator.getPassword();
        }
        String openId = ParamUtil.getString((PortletRequest)actionRequest, (String)"openId");
        String firstName = ParamUtil.getString((PortletRequest)actionRequest, (String)"firstName");
        String middleName = ParamUtil.getString((PortletRequest)actionRequest, (String)"middleName");
        String lastName = ParamUtil.getString((PortletRequest)actionRequest, (String)"lastName");
        long prefixId = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"prefixId");
        long suffixId = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"suffixId");
        boolean male = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"male", (boolean)true);
        int birthdayMonth = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"birthdayMonth");
        int birthdayDay = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"birthdayDay");
        int birthdayYear = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"birthdayYear");
        String jobTitle = ParamUtil.getString((PortletRequest)actionRequest, (String)"jobTitle");
        boolean updateUserInformation = true;
        boolean sendEmail = true;
        if (Validator.isNotNull((String)googleUserId)) {
            sendEmail = false;
        }
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)User.class.getName(), (PortletRequest)actionRequest);
        User user = this._userService.updateIncompleteUser(themeDisplay.getCompanyId(), autoPassword, password1, password2, autoScreenName, screenName, emailAddress, facebookId, openId, themeDisplay.getLocale(), firstName, middleName, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, jobTitle, updateUserInformation, sendEmail, serviceContext);
        if (facebookId > 0L) {
            session.removeAttribute("FACEBOOK_INCOMPLETE_USER_ID");
            this.updateUserAndSendRedirect(actionRequest, actionResponse, themeDisplay, user, password1);
            return;
        }
        if (Validator.isNotNull((String)googleUserId)) {
            this._userLocalService.updateGoogleUserId(user.getUserId(), googleUserId);
            session.removeAttribute("GOOGLE_INCOMPLETE_USER_ID");
            this.updateUserAndSendRedirect(actionRequest, actionResponse, themeDisplay, user, password1);
            return;
        }
        if (user.getStatus() == 0) {
            SessionMessages.add((HttpServletRequest)request, (String)"userAdded", (Object)user.getEmailAddress());
            SessionMessages.add((HttpServletRequest)request, (String)"userAddedPassword", (Object)user.getPasswordUnencrypted());
        } else {
            SessionMessages.add((HttpServletRequest)request, (String)"userPending", (Object)user.getEmailAddress());
        }
        this.sendRedirect(actionRequest, actionResponse, themeDisplay, user, user.getPasswordUnencrypted());
    }

    protected void updateUserAndSendRedirect(ActionRequest actionRequest, ActionResponse actionResponse, ThemeDisplay themeDisplay, User user, String password1) throws Exception {
        this._userLocalService.updateLastLogin(user.getUserId(), user.getLoginIP());
        this._userLocalService.updatePasswordReset(user.getUserId(), false);
        this._userLocalService.updateEmailAddressVerified(user.getUserId(), true);
        this.sendRedirect(actionRequest, actionResponse, themeDisplay, user, password1);
    }

    private ActionRequest _wrapActionRequest(ActionRequest actionRequest) throws Exception {
        DynamicActionRequest dynamicActionRequest = new DynamicActionRequest(actionRequest);
        long prefixId = this.getListTypeId((PortletRequest)actionRequest, "prefixValue", ListTypeConstants.CONTACT_PREFIX);
        dynamicActionRequest.setParameter("prefixId", String.valueOf(prefixId));
        long suffixId = this.getListTypeId((PortletRequest)actionRequest, "suffixValue", ListTypeConstants.CONTACT_SUFFIX);
        dynamicActionRequest.setParameter("suffixId", String.valueOf(suffixId));
        return dynamicActionRequest;
    }
}

