/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.login.authentication.opensso.web.internal.servlet.taglib;

import com.liferay.portal.kernel.exception.ContactNameException;
import com.liferay.portal.kernel.exception.UserEmailAddressException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.sso.OpenSSO;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.servlet.taglib.BaseJSPDynamicInclude;
import com.liferay.portal.kernel.servlet.taglib.DynamicInclude;
import com.liferay.portal.kernel.settings.CompanyServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.sso.opensso.configuration.OpenSSOConfiguration;
import com.liferay.portal.security.sso.opensso.exception.StrangersNotAllowedException;
import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={DynamicInclude.class})
public class OpenSSOBottomJSPDynamicInclude
extends BaseJSPDynamicInclude {
    private static final String[] _ERRORS = new String[]{ContactNameException.class.getSimpleName(), PrincipalException.MustBeAuthenticated.class.getSimpleName(), StrangersNotAllowedException.class.getSimpleName(), UserEmailAddressException.MustNotUseCompanyMx.class.getSimpleName()};
    private static final Log _log = LogFactoryUtil.getLog(OpenSSOBottomJSPDynamicInclude.class);
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private OpenSSO _openSSO;
    @Reference
    private Portal _portal;

    public void include(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String key) throws IOException {
        try {
            OpenSSOConfiguration openSSOConfiguration = (OpenSSOConfiguration)this._configurationProvider.getConfiguration(OpenSSOConfiguration.class, (SettingsLocator)new CompanyServiceSettingsLocator(this._portal.getCompanyId(httpServletRequest), "com.liferay.portal.security.sso.opensso"));
            if (!openSSOConfiguration.enabled()) {
                return;
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return;
        }
        HttpServletRequest originalHttpServletRequest = this._portal.getOriginalServletRequest(httpServletRequest);
        String error = (String)originalHttpServletRequest.getAttribute("OPEN_SSO_ERROR");
        if (Validator.isBlank((String)error)) {
            return;
        }
        originalHttpServletRequest.removeAttribute("OPEN_SSO_ERROR");
        if (ArrayUtil.contains((Object[])_ERRORS, (Object)error)) {
            SessionMessages.add((HttpServletRequest)httpServletRequest, (String)error);
        }
        super.include(httpServletRequest, httpServletResponse, key);
    }

    public void register(DynamicInclude.DynamicIncludeRegistry dynamicIncludeRegistry) {
        dynamicIncludeRegistry.register("/html/common/themes/bottom.jsp#post");
    }

    protected String getJspPath() {
        return "/dynamic_include/com.liferay.portal/opensso_error.jsp";
    }

    protected Log getLog() {
        return _log;
    }

    @Reference(target="(osgi.web.symbolicname=com.liferay.login.authentication.opensso.web)", unbind="-")
    protected void setServletContext(ServletContext servletContext) {
        super.setServletContext(servletContext);
    }
}

