/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.login.authentication.openid.connect.web.internal.portlet.action;

import com.liferay.portal.kernel.exception.UserEmailAddressException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.security.sso.openid.connect.OpenIdConnect;
import com.liferay.portal.security.sso.openid.connect.OpenIdConnectServiceException;
import com.liferay.portal.security.sso.openid.connect.OpenIdConnectServiceHandler;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"auth.token.ignore.mvc.action=true", "javax.portlet.name=com_liferay_login_web_portlet_FastLoginPortlet", "javax.portlet.name=com_liferay_login_web_portlet_LoginPortlet", "mvc.command.name=/login/openid_connect_request"}, service={MVCActionCommand.class})
public class OpenIdConnectLoginRequestMVCActionCommand
extends BaseMVCActionCommand {
    private static final Log _log = LogFactoryUtil.getLog(OpenIdConnectLoginRequestMVCActionCommand.class);
    @Reference
    private OpenIdConnect _openIdConnect;
    @Reference
    private OpenIdConnectServiceHandler _openIdConnectServiceHandler;
    @Reference
    private Portal _portal;

    public void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        try {
            String openIdConnectProviderName = ParamUtil.getString((PortletRequest)actionRequest, (String)"OPEN_ID_CONNECT_PROVIDER_NAME");
            HttpServletRequest httpServletRequest = this._portal.getHttpServletRequest((PortletRequest)actionRequest);
            httpServletRequest = this._portal.getOriginalServletRequest(httpServletRequest);
            HttpServletResponse httpServletResponse = this._portal.getHttpServletResponse((PortletResponse)actionResponse);
            this._openIdConnectServiceHandler.requestAuthentication(openIdConnectProviderName, httpServletRequest, httpServletResponse);
        }
        catch (Exception e) {
            if (e instanceof OpenIdConnectServiceException) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Unable to communicate with OpenID Connect provider: " + e.getMessage()));
                }
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            }
            if (e instanceof UserEmailAddressException.MustNotBeDuplicate) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            }
            _log.error((Object)"Unable to process the OpenID login", (Throwable)e);
            this._portal.sendError(e, actionRequest, actionResponse);
        }
    }
}

