/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.login.authentication.facebook.connect.web.internal.portlet.action;

import com.liferay.portal.kernel.exception.UserEmailAddressException;
import com.liferay.portal.kernel.facebook.FacebookConnect;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCRenderCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCRenderConstants;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.security.sso.facebook.connect.exception.MustVerifyEmailAddressException;
import com.liferay.portal.security.sso.facebook.connect.exception.StrangersNotAllowedException;
import com.liferay.portal.security.sso.facebook.connect.exception.UnknownErrorException;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_login_web_portlet_FastLoginPortlet", "javax.portlet.name=com_liferay_login_web_portlet_LoginPortlet", "mvc.command.name=/login/facebook_connect_login_error"}, service={MVCRenderCommand.class})
public class FacebookConnectLoginErrorMVCRenderCommand
implements MVCRenderCommand {
    private static final String[] _ERRORS = new String[]{UserEmailAddressException.MustNotUseCompanyMx.class.getSimpleName(), MustVerifyEmailAddressException.class.getSimpleName(), StrangersNotAllowedException.class.getSimpleName()};
    @Reference
    private FacebookConnect _facebookConnect;
    @Reference
    private Portal _portal;
    @Reference(target="(osgi.web.symbolicname=com.liferay.login.authentication.facebook.connect.web)")
    private ServletContext _servletContext;
    @Reference
    private UserLocalService _userLocalService;

    public String render(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException {
        ThemeDisplay themeDisplay = (ThemeDisplay)renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (!this._facebookConnect.isEnabled(themeDisplay.getCompanyId())) {
            throw new PortletException((Throwable)new PrincipalException.MustBeEnabled(themeDisplay.getCompanyId(), new String[]{FacebookConnect.class.getName()}));
        }
        String error = ParamUtil.getString((PortletRequest)renderRequest, (String)"error");
        if (ArrayUtil.contains((Object[])_ERRORS, (Object)error)) {
            SessionErrors.add((PortletRequest)renderRequest, (String)error);
        } else {
            SessionErrors.add((PortletRequest)renderRequest, (String)UnknownErrorException.class.getSimpleName());
        }
        HttpServletRequest httpServletRequest = this._portal.getHttpServletRequest((PortletRequest)renderRequest);
        HttpServletResponse httpServletResponse = this._portal.getHttpServletResponse((PortletResponse)renderResponse);
        try {
            RequestDispatcher requestDispatcher = this._servletContext.getRequestDispatcher("/error.jsp");
            requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
        catch (Exception e) {
            throw new PortletException("Unable to include error.jsp", (Throwable)e);
        }
        return MVCRenderConstants.MVC_PATH_VALUE_SKIP_DISPATCH;
    }
}

