/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.login.authentication.facebook.connect.web.internal.portlet.action;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.UserEmailAddressException;
import com.liferay.portal.kernel.facebook.FacebookConnect;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.struts.StrutsAction;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.sso.facebook.connect.exception.MustVerifyEmailAddressException;
import com.liferay.portal.security.sso.facebook.connect.exception.StrangersNotAllowedException;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.portlet.PortletMode;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"/common/referer_jsp.jsp=/common/referer_jsp.jsp", "path=/portal/facebook_connect_oauth"}, service={StrutsAction.class})
public class FacebookConnectAction
implements StrutsAction {
    private static final Log _log = LogFactoryUtil.getLog(FacebookConnectAction.class);
    @Reference
    private CompanyLocalService _companyLocalService;
    private FacebookConnect _facebookConnect;
    private String _forward;
    @Reference
    private Portal _portal;
    private UserLocalService _userLocalService;

    public String execute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String redirect;
        block9: {
            ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            if (!this._facebookConnect.isEnabled(themeDisplay.getCompanyId())) {
                throw new PrincipalException.MustBeEnabled(themeDisplay.getCompanyId(), new String[]{FacebookConnect.class.getName()});
            }
            HttpSession session = httpServletRequest.getSession();
            String nonce = (String)session.getAttribute("FACEBOOK_NONCE");
            String state = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"state");
            JSONObject stateJSONObject = JSONFactoryUtil.createJSONObject((String)state);
            String stateNonce = stateJSONObject.getString("stateNonce");
            if (!stateNonce.equals(nonce)) {
                throw new PrincipalException.MustHaveValidCSRFToken(this._portal.getUserId(httpServletRequest), FacebookConnectAction.class.getName());
            }
            if (!Validator.isBlank((String)ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"error"))) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Authentication error: " + httpServletRequest.getQueryString()));
                }
                return this._forward;
            }
            redirect = stateJSONObject.getString("redirect");
            redirect = this._portal.escapeRedirect(redirect);
            String code = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"code");
            String token = this._facebookConnect.getAccessToken(themeDisplay.getCompanyId(), redirect, code);
            if (Validator.isNotNull((String)token)) {
                try {
                    User user = this.setFacebookCredentials(session, themeDisplay.getCompanyId(), token);
                    if (user != null && user.getStatus() == 6) {
                        this.redirectUpdateAccount(httpServletRequest, httpServletResponse, user);
                        return null;
                    }
                    break block9;
                }
                catch (PortalException pe) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)pe, (Throwable)pe);
                    }
                    Class<?> clazz = ((Object)((Object)pe)).getClass();
                    this.sendError(clazz.getSimpleName(), httpServletRequest, httpServletResponse);
                    return null;
                }
            }
            return this._forward;
        }
        httpServletResponse.sendRedirect(redirect);
        return null;
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._forward = GetterUtil.getString(properties, (String)"/common/referer_jsp.jsp");
    }

    protected User addUser(HttpSession session, long companyId, JSONObject jsonObject) throws Exception {
        long creatorUserId = 0L;
        boolean autoPassword = true;
        String password1 = "";
        String password2 = "";
        boolean autoScreenName = true;
        String screenName = "";
        String emailAddress = jsonObject.getString("email");
        long facebookId = jsonObject.getLong("id");
        String openId = "";
        Locale locale = LocaleUtil.getDefault();
        String firstName = jsonObject.getString("first_name");
        String middleName = "";
        String lastName = jsonObject.getString("last_name");
        long prefixId = 0L;
        long suffixId = 0L;
        boolean male = Objects.equals(jsonObject.getString("gender"), "male");
        int birthdayMonth = 0;
        int birthdayDay = 1;
        int birthdayYear = 1970;
        String jobTitle = "";
        long[] groupIds = null;
        long[] organizationIds = null;
        long[] roleIds = null;
        long[] userGroupIds = null;
        boolean sendEmail = true;
        ServiceContext serviceContext = new ServiceContext();
        User user = this._userLocalService.addUser(creatorUserId, companyId, autoPassword, password1, password2, autoScreenName, screenName, emailAddress, facebookId, openId, locale, firstName, middleName, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, jobTitle, groupIds, organizationIds, roleIds, userGroupIds, sendEmail, serviceContext);
        user = this._userLocalService.updateLastLogin(user.getUserId(), user.getLoginIP());
        user = this._userLocalService.updatePasswordReset(user.getUserId(), false);
        user = this._userLocalService.updateEmailAddressVerified(user.getUserId(), true);
        session.setAttribute("FACEBOOK_USER_EMAIL_ADDRESS", (Object)emailAddress);
        return user;
    }

    protected void redirectUpdateAccount(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, User user) throws Exception {
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create((HttpServletRequest)httpServletRequest, (String)"com_liferay_login_web_portlet_LoginPortlet", (String)"RENDER_PHASE");
        portletURL.setParameter("saveLastPath", Boolean.FALSE.toString());
        portletURL.setParameter("mvcRenderCommandName", "/login/associate_facebook_user");
        portletURL.setParameter("redirect", ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"redirect"));
        portletURL.setParameter("userId", String.valueOf(user.getUserId()));
        portletURL.setParameter("emailAddress", user.getEmailAddress());
        portletURL.setParameter("firstName", user.getFirstName());
        portletURL.setParameter("lastName", user.getLastName());
        portletURL.setPortletMode(PortletMode.VIEW);
        portletURL.setWindowState(LiferayWindowState.POP_UP);
        httpServletResponse.sendRedirect(portletURL.toString());
    }

    protected void sendError(String error, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create((HttpServletRequest)httpServletRequest, (String)"com_liferay_login_web_portlet_LoginPortlet", (String)"RENDER_PHASE");
        portletURL.setParameter("mvcRenderCommandName", "/login/facebook_connect_login_error");
        portletURL.setParameter("error", error);
        portletURL.setWindowState(LiferayWindowState.POP_UP);
        httpServletResponse.sendRedirect(portletURL.toString());
    }

    @Reference(unbind="-")
    protected void setFacebookConnect(FacebookConnect facebookConnect) {
        this._facebookConnect = facebookConnect;
    }

    protected User setFacebookCredentials(HttpSession session, long companyId, String token) throws Exception {
        JSONObject jsonObject = this._facebookConnect.getGraphResources(companyId, "/me", token, "id,email,first_name,last_name,gender,verified");
        if (jsonObject == null || jsonObject.getJSONObject("error") != null) {
            return null;
        }
        if (this._facebookConnect.isVerifiedAccountRequired(companyId) && !jsonObject.getBoolean("verified")) {
            throw new MustVerifyEmailAddressException(companyId);
        }
        User user = null;
        long facebookId = jsonObject.getLong("id");
        if (facebookId > 0L) {
            session.setAttribute("FACEBOOK_ACCESS_TOKEN", (Object)token);
            user = this._userLocalService.fetchUserByFacebookId(companyId, facebookId);
            if (user != null && !user.isActive()) {
                return null;
            }
            if (user != null && user.getStatus() != 6) {
                session.setAttribute("FACEBOOK_USER_ID", (Object)String.valueOf(facebookId));
            }
        }
        String emailAddress = jsonObject.getString("email");
        if (user == null && Validator.isNotNull((String)emailAddress)) {
            user = this._userLocalService.fetchUserByEmailAddress(companyId, emailAddress);
            if (user != null && !user.isActive()) {
                return null;
            }
            if (user != null && user.getStatus() != 6) {
                session.setAttribute("FACEBOOK_USER_EMAIL_ADDRESS", (Object)emailAddress);
            }
        }
        if (user != null) {
            if (user.getStatus() == 6) {
                session.setAttribute("FACEBOOK_INCOMPLETE_USER_ID", (Object)facebookId);
                user.setEmailAddress(jsonObject.getString("email"));
                user.setFirstName(jsonObject.getString("first_name"));
                user.setLastName(jsonObject.getString("last_name"));
                return user;
            }
            user = this.updateUser(user, jsonObject);
        } else {
            this._checkAllowUserCreation(companyId, jsonObject);
            user = this.addUser(session, companyId, jsonObject);
        }
        return user;
    }

    @Reference(unbind="-")
    protected void setUserLocalService(UserLocalService userLocalService) {
        this._userLocalService = userLocalService;
    }

    protected User updateUser(User user, JSONObject jsonObject) throws Exception {
        long facebookId = jsonObject.getLong("id");
        String emailAddress = jsonObject.getString("email");
        String firstName = jsonObject.getString("first_name");
        String lastName = jsonObject.getString("last_name");
        boolean male = Objects.equals(jsonObject.getString("gender"), "male");
        if (facebookId == user.getFacebookId() && emailAddress.equals(user.getEmailAddress()) && firstName.equals(user.getFirstName()) && lastName.equals(user.getLastName()) && male == user.isMale()) {
            return user;
        }
        Contact contact = user.getContact();
        Calendar birthdayCal = CalendarFactoryUtil.getCalendar();
        birthdayCal.setTime(contact.getBirthday());
        int birthdayMonth = birthdayCal.get(2);
        int birthdayDay = birthdayCal.get(5);
        int birthdayYear = birthdayCal.get(1);
        long[] groupIds = null;
        long[] organizationIds = null;
        long[] roleIds = null;
        List userGroupRoles = null;
        long[] userGroupIds = null;
        ServiceContext serviceContext = new ServiceContext();
        if (!StringUtil.equalsIgnoreCase((String)emailAddress, (String)user.getEmailAddress())) {
            this._userLocalService.updateEmailAddress(user.getUserId(), "", emailAddress, emailAddress);
        }
        this._userLocalService.updateEmailAddressVerified(user.getUserId(), true);
        return this._userLocalService.updateUser(user.getUserId(), "", "", "", false, user.getReminderQueryQuestion(), user.getReminderQueryAnswer(), user.getScreenName(), emailAddress, facebookId, user.getOpenId(), true, null, user.getLanguageId(), user.getTimeZoneId(), user.getGreeting(), user.getComments(), firstName, user.getMiddleName(), lastName, contact.getPrefixId(), contact.getSuffixId(), male, birthdayMonth, birthdayDay, birthdayYear, contact.getSmsSn(), contact.getFacebookSn(), contact.getJabberSn(), contact.getSkypeSn(), contact.getTwitterSn(), contact.getJobTitle(), groupIds, organizationIds, roleIds, userGroupRoles, userGroupIds, serviceContext);
    }

    private void _checkAllowUserCreation(long companyId, JSONObject jsonObject) throws PortalException {
        Company company = this._companyLocalService.getCompany(companyId);
        if (!company.isStrangers()) {
            throw new StrangersNotAllowedException(companyId);
        }
        String emailAddress = jsonObject.getString("email");
        if (company.hasCompanyMx(emailAddress) && !company.isStrangersWithMx()) {
            throw new UserEmailAddressException.MustNotUseCompanyMx(emailAddress);
        }
    }
}

