/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.server.Components;
import com.launchdarkly.sdk.server.integrations.ApplicationInfoBuilder;
import com.launchdarkly.sdk.server.integrations.ServiceEndpointsBuilder;
import com.launchdarkly.sdk.server.interfaces.ApplicationInfo;
import com.launchdarkly.sdk.server.interfaces.BigSegmentsConfiguration;
import com.launchdarkly.sdk.server.interfaces.ServiceEndpoints;
import com.launchdarkly.sdk.server.subsystems.ComponentConfigurer;
import com.launchdarkly.sdk.server.subsystems.DataSource;
import com.launchdarkly.sdk.server.subsystems.DataStore;
import com.launchdarkly.sdk.server.subsystems.EventProcessor;
import com.launchdarkly.sdk.server.subsystems.HttpConfiguration;
import com.launchdarkly.sdk.server.subsystems.LoggingConfiguration;
import java.time.Duration;

public final class LDConfig {
    public static final Duration DEFAULT_START_WAIT = Duration.ofSeconds(5L);
    protected static final LDConfig DEFAULT = new Builder().build();
    final ApplicationInfo applicationInfo;
    final ComponentConfigurer<BigSegmentsConfiguration> bigSegments;
    final ComponentConfigurer<DataSource> dataSource;
    final ComponentConfigurer<DataStore> dataStore;
    final boolean diagnosticOptOut;
    final ComponentConfigurer<EventProcessor> events;
    final ComponentConfigurer<HttpConfiguration> http;
    final ComponentConfigurer<LoggingConfiguration> logging;
    final ServiceEndpoints serviceEndpoints;
    final boolean offline;
    final Duration startWait;
    final int threadPriority;

    protected LDConfig(Builder builder) {
        if (builder.offline) {
            this.dataSource = Components.externalUpdatesOnly();
            this.events = Components.noEvents();
        } else {
            this.dataSource = builder.dataSource == null ? Components.streamingDataSource() : builder.dataSource;
            this.events = builder.events == null ? Components.sendEvents() : builder.events;
        }
        this.applicationInfo = (builder.applicationInfoBuilder == null ? Components.applicationInfo() : builder.applicationInfoBuilder).createApplicationInfo();
        this.bigSegments = builder.bigSegments == null ? Components.bigSegments(null) : builder.bigSegments;
        this.dataStore = builder.dataStore == null ? Components.inMemoryDataStore() : builder.dataStore;
        this.diagnosticOptOut = builder.diagnosticOptOut;
        this.http = builder.http == null ? Components.httpConfiguration() : builder.http;
        this.logging = builder.logging == null ? Components.logging() : builder.logging;
        this.offline = builder.offline;
        this.serviceEndpoints = (builder.serviceEndpointsBuilder == null ? Components.serviceEndpoints() : builder.serviceEndpointsBuilder).createServiceEndpoints();
        this.startWait = builder.startWait;
        this.threadPriority = builder.threadPriority;
    }

    public static class Builder {
        private ApplicationInfoBuilder applicationInfoBuilder = null;
        private ComponentConfigurer<BigSegmentsConfiguration> bigSegments = null;
        private ComponentConfigurer<DataSource> dataSource = null;
        private ComponentConfigurer<DataStore> dataStore = null;
        private boolean diagnosticOptOut = false;
        private ComponentConfigurer<EventProcessor> events = null;
        private ComponentConfigurer<HttpConfiguration> http = null;
        private ComponentConfigurer<LoggingConfiguration> logging = null;
        private ServiceEndpointsBuilder serviceEndpointsBuilder = null;
        private boolean offline = false;
        private Duration startWait = DEFAULT_START_WAIT;
        private int threadPriority = 1;

        public Builder applicationInfo(ApplicationInfoBuilder applicationInfoBuilder) {
            this.applicationInfoBuilder = applicationInfoBuilder;
            return this;
        }

        public Builder bigSegments(ComponentConfigurer<BigSegmentsConfiguration> bigSegmentsConfigurer) {
            this.bigSegments = bigSegmentsConfigurer;
            return this;
        }

        public Builder dataSource(ComponentConfigurer<DataSource> dataSourceConfigurer) {
            this.dataSource = dataSourceConfigurer;
            return this;
        }

        public Builder dataStore(ComponentConfigurer<DataStore> dataStoreConfigurer) {
            this.dataStore = dataStoreConfigurer;
            return this;
        }

        public Builder diagnosticOptOut(boolean diagnosticOptOut) {
            this.diagnosticOptOut = diagnosticOptOut;
            return this;
        }

        public Builder events(ComponentConfigurer<EventProcessor> eventsConfigurer) {
            this.events = eventsConfigurer;
            return this;
        }

        public Builder http(ComponentConfigurer<HttpConfiguration> httpConfigurer) {
            this.http = httpConfigurer;
            return this;
        }

        public Builder logging(ComponentConfigurer<LoggingConfiguration> loggingConfigurer) {
            this.logging = loggingConfigurer;
            return this;
        }

        public Builder offline(boolean offline) {
            this.offline = offline;
            return this;
        }

        public Builder serviceEndpoints(ServiceEndpointsBuilder serviceEndpointsBuilder) {
            this.serviceEndpointsBuilder = serviceEndpointsBuilder;
            return this;
        }

        public Builder startWait(Duration startWait) {
            this.startWait = startWait == null ? DEFAULT_START_WAIT : startWait;
            return this;
        }

        public Builder threadPriority(int threadPriority) {
            this.threadPriority = Math.max(1, Math.min(10, threadPriority));
            return this;
        }

        public LDConfig build() {
            return new LDConfig(this);
        }
    }
}

